import React, {useEffect, useState} from 'react';
import Link from 'next/link'; 
import { useRouter } from 'next/router'; 
import Head from 'next/head'; 

// Utils
import { userService } from '@/services/user.service'; 
import { fetchWrapper } from '@/helpers/fetch-wrapper'; 

// Form Validation
import { useForm } from 'react-hook-form';

// Toast Notification 
import { toast } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';

import StudentDashboardHeader from "@/components/Student/StudentDashboardHeader";
import StudentDashboardSidebar from "@/components/Student/StudentDashboardSidebar";

const StudentSetting = () => {
     const user = userService.userValue ? (true):(false);

     const router = useRouter(); 

     const [userData, setUserData] = useState([]); 

     const [firstName, setFirstName] = useState(''); 
     const [surName, setSurName] = useState(''); 
     const [phoneNumber, setPhoneNumber] = useState(''); 
     const [bioText, setBioText] = useState(''); 

     const [facebook, setFacebook] = useState(''); 
     const [twitter, setTwitter] = useState(''); 
     const [linkedin, setLinkedin] = useState(''); 
     const [github, setGithub] = useState(''); 

     useEffect(() => {
          if(user) {
               async function fetchUserData() {
                    const response = await fetchWrapper.get(`/api/users/getdata`);

                    setUserData(response[0].userData);

                    if(response[0].userData.accountType != 0){
                         return router.replace('/'); 
                    }

                    setBioText(response[0].userData.bio); 

                    setFirstName(response[0].userData.firstName); 
                    setSurName(response[0].userData.surName); 
                    setPhoneNumber(response[0].userData.phoneNumber); 

                    setFacebook(response[0].userData.facebook); 
                    setTwitter(response[0].userData.twitter); 
                    setLinkedin(response[0].userData.linkedin); 
                    setGithub(response[0].userData.github); 
               };
               fetchUserData();
          }
          else router.push('/autentificare'); 
     }, []);

     const { register, handleSubmit, formState: { errors }, watch } = useForm();
     const { register: passwords, handleSubmit: handleSubmitPasswords, formState: { error } } = useForm();
     const { register: socials, handleSubmit: handleSubmitSocials, formState: { errorSocials }} = useForm(); 

     const onSubmitSocials = async () => {
          alert(facebook); 
          if (!facebook.includes('https://facebook.com/') && !facebook.includes('https://www.facebook.com/') && facebook.length > 1) 
               return toast.error('Link-ul destinat pentru facebook nu este corect. Trebuie sa contina https://facebook.com/ in structura sa.');
 
          if (!twitter.includes('https://twitter.com/') && !twitter.includes('https://www.twitter.com/') && twitter.length > 1) 
               return toast.error('Link-ul destinat pentru facebook nu este corect. Trebuie sa contina https://twitter.com/ in structura sa.');

          if (!linkedin.includes('https://linkedin.com/') && !linkedin.includes('https://www.linkedin.com/') && linkedin.length > 1) 
               return toast.error('Link-ul destinat pentru facebook nu este corect. Trebuie sa contina https://linkedin.com/ in structura sa.');

          if (!github.includes('https://github.com/') && !github.includes('https://www.github.com/') && github.length > 1) 
               return toast.error('Link-ul destinat pentru facebook nu este corect. Trebuie sa contina https://github.com/ in structura sa.');

          const response = await fetchWrapper.post('/api/users/settings_socials', { facebook, twitter, linkedin, github }); 

          if (!response.status) {
               toast.error('Oops! Am intampinat o problema, te rugam sa incerci mai tarziu.');
          }
          
          toast.success(response.message); 
      
          return; 
     };

     const onSubmitPasswordChange = async (data) => {
          const response = await fetchWrapper.post('/api/users/settings_password', data);

          if (!response.status) {
               toast.error(response.error);
          }
          
          toast.success(response.message); 
      
          return; 
     };

     const onSubmit = async () => {
          if(firstName.length < 5) 
               return toast.error('Prenumele trebuie sa contina minim 5 caractere.'); 

          if(surName.length < 5) 
               return toast.error('Numele de familie trebuie sa contina minim 5 caractere.'); 

          if(phoneNumber.length < 10) 
               return toast.error('Numarul de telefon trebuie sa contina minim 10 caractere.'); 

          if(bioText.length < 20)
               return toast.error('Biografia trebuie sa contina minim 20 de caractere.');

          try {
               const response = await fetchWrapper.post('/api/users/settings_profile', {firstName, surName, phoneNumber, bioText}); 

               if(response.status == 200){ 
                    toast.success('Datele au fost actualizate cu succes!'); 
               }
          }
          catch(err) {
               toast.error('Oops, am identificat o problema, va rugam sa reincercati mai tarziu!'); 
          }
     };

	return (
		<>
			               <Head>
                    <meta name="robots" content="noindex, nofollow"/>  
                    <title>Profilul meu - Setari</title>
               </Head>

					<div className='rbt-page-banner-wrapper'>
						<div className='rbt-banner-image' />
					</div>
					<div className='rbt-dashboard-area rbt-section-overlayping-top rbt-section-gapBottom'>
						<div className='container'>
							<div className='row'>
								<div className='col-lg-12'>
                                             <StudentDashboardHeader userData={userData}/>

									<div className='row g-5'>
										<div className='col-lg-3'>
											<StudentDashboardSidebar />
										</div>

										<div className='col-lg-9'>
                                                       <div className='rbt-dashboard-content bg-color-white rbt-shadow-box'>
                                                            <div className='content'>
                                                                 <div className='section-title'>
                                                                      <h4 className='rbt-title-style-3'><i className="feather-settings"></i> Setari</h4>
                                                                 </div>

                                                                 <div className='advance-tab-button mb--30'>
                                                                      <ul
                                                                           className='nav nav-tabs tab-button-style-2 justify-content-start'
                                                                           id='settinsTab-4'
                                                                           role='tablist'
                                                                      >
                                                                           <li role='presentation'>
                                                                                <Link
                                                                                     href='#'
                                                                                     className='tab-button active'
                                                                                     id='profile-tab'
                                                                                     data-bs-toggle='tab'
                                                                                     data-bs-target='#profile'
                                                                                     role='tab'
                                                                                     aria-controls='profile'
                                                                                     aria-selected='true'
                                                                                >
                                                                                     <span className='title'>
                                                                                          Profil
                                                                                     </span>
                                                                                </Link>
                                                                           </li>
                                                                           <li role='presentation'>
                                                                                <Link
                                                                                     href='#'
                                                                                     className='tab-button'
                                                                                     id='password-tab'
                                                                                     data-bs-toggle='tab'
                                                                                     data-bs-target='#password'
                                                                                     role='tab'
                                                                                     aria-controls='password'
                                                                                     aria-selected='false'
                                                                                >
                                                                                     <span className='title'>
                                                                                          Parola
                                                                                     </span>
                                                                                </Link>
                                                                           </li>
                                                                           <li role='presentation'>
                                                                                <Link
                                                                                     href='#'
                                                                                     className='tab-button'
                                                                                     id='social-tab'
                                                                                     data-bs-toggle='tab'
                                                                                     data-bs-target='#social'
                                                                                     role='tab'
                                                                                     aria-controls='social'
                                                                                     aria-selected='false'
                                                                                >
                                                                                     <span className='title'>
                                                                                          Social Share
                                                                                     </span>
                                                                                </Link>
                                                                           </li>
                                                                      </ul>
                                                                 </div>

                                                                 <div className='tab-content'>
                                                                      <div
                                                                           className='tab-pane fade active show'
                                                                           id='profile'
                                                                           role='tabpanel'
                                                                           aria-labelledby='profile-tab'
                                                                      >
                   
                                                                           <form
                                                                                onSubmit={handleSubmitSocials(onSubmit)}
                                                                                className='rbt-profile-row rbt-default-form row row--15'
                                                                           >
                                                                                <div className='col-lg-6 col-md-6 col-sm-6 col-12'>
                                                                                     <div className='rbt-form-group'>
                                                                                          <label htmlFor='surName'>
                                                                                               Nume de familie 
                                                                                          </label>
                                                                                          <input
                                                                                               id='surName'
                                                                                               name="surName"
                                                                                               type='text'
                                                                                               value={surName}
                                                                                               onChange={(e) =>
                                                                                                    setSurName(
                                                                                                         e.target.value
                                                                                                    )
                                                                                               }
                                                                                      
                                                                                          />
                                                                                         
                                                                                     </div>
                                                                                </div>

                                                                                <div className='col-lg-6 col-md-6 col-sm-6 col-12'>
                                                                                     <div className='rbt-form-group'>
                                                                                          <label htmlFor='firstName'>
                                                                                               Prenume 
                                                                                          </label>
                                                                                          <input
                                                                                               id='firstName'
                                                                                               name="firstName"
                                                                                               type='text'
                                                                                               defaultValue={firstName}
                                                                                               onChange={(e) =>
                                                                                                    setFirstName(
                                                                                                         e.target.value
                                                                                                    )
                                                                                               }
                                                                                               
                                                                                          />
                                                                            
                                                                                     </div>
                                                                                </div>

                                                                                <div className='col-lg-6 col-md-6 col-sm-6 col-12'>
                                                                                     <div className='rbt-form-group'>
                                                                                          <label htmlFor='phoneNumber'>
                                                                                               Numar de telefon
                                                                                          </label>
                                                                                          <input
                                                                                               id='phoneNumber'
                                                                                               name="phoneNumber"
                                                                                               type='tel'
                                                                                               defaultValue={phoneNumber}
                                                                                               onChange={(e) =>
                                                                                                    setPhoneNumber(
                                                                                                         e.target.value
                                                                                                    )
                                                                                               }
                                                                                        
                                                                                          />
                                                                                          
                                                                                     </div>
                                                                                </div>
                                                                               
                                                                                <div className='col-12'>
                                                                                     <div className='rbt-form-group'>
                                                                                          <label htmlFor='bio'>
                                                                                               Bio
                                                                                          </label>
                                                                                          <textarea
                                                                                               id='bio'
                                                                                               cols='20'
                                                                                               rows='5'
                                                                                               defaultValue={bioText}
                                                                                               onChange={(e) =>
                                                                                                    setBioText(
                                                                                                         e.target.value
                                                                                                    )
                                                                                               }
                                                                                             
                                                                                          ></textarea>
                                                                                    
                                                                                     </div>
                                                                                </div>
                                                                                <div className='col-12 mt--20'>
                                                                                     <div className='rbt-form-group'>
                                                                                          <button
                                                                                               type='submit'
                                                                                               className='rbt-btn btn-gradient'
                                                                                          >
                                                                                               <i className="feather-refresh-ccw"></i> Actualizeaza
                                                                                          </button>
                                                                                     </div>
                                                                                </div>
                                                                           </form>
                                                                      </div>

                                                                      <div
                                                                           className='tab-pane fade'
                                                                           id='password'
                                                                           role='tabpanel'
                                                                           aria-labelledby='password-tab'
                                                                      >
                                                                           <form
                                                                                onSubmit={handleSubmitPasswords(onSubmitPasswordChange)}
                                                                                className='rbt-profile-row rbt-default-form row row--15'
                                                                           >
                                                                                <div className='col-12'>
                                                                                     <div className='rbt-form-group'>
                                                                                          <label htmlFor='currentpassword'>
                                                                                               Parola curenta
                                                                                          </label>
                                                                                          <input
                                                                                               id='currentpassword'
                                                                                               type='password'
                                                                                               placeholder='Current Password'
                                                                                               {...passwords('currentPassword', { required: true })} 
                                                                                          />
                                                                                          {errors.currentPassword && <span style={{ fontSize: 15 }} className="error">Trebuie sa introduci parola curenta!</span>}
                                                                                     </div>
                                                                                </div>
                                                                                <div className='col-12'>
                                                                                     <div className='rbt-form-group'>
                                                                                          <label htmlFor='newpassword'>
                                                                                               Noua parola
                                                                                          </label>
                                                                                          <input
                                                                                               id='newpassword'
                                                                                               type='password'
                                                                                               placeholder='New Password'
                                                                                               {...passwords('newPassword', { required: true })} 
                                                                                          />
                                                                                          {errors.newPassword && <span style={{ fontSize: 15 }} className="error">Trebuie sa introduci noua parola !</span>}
                                                                                     </div>
                                                                                </div>
                                                                                <div className='col-12'>
                                                                                     <div className='rbt-form-group'>
                                                                                          <label htmlFor='retypenewpassword'>
                                                                                               Rescrie noua parola
                                                                                          </label>
                                                                                          <input
                                                                                               id='retypenewpassword'
                                                                                               type='password'
                                                                                               placeholder='Re-type New Password'
                                                                                               {...passwords('retypePassword', { required: true })} 
                                                                                          />
                                                                                          {errors.retypePassword && <span style={{ fontSize: 15 }} className="error">Trebuie sa introduci noua parola din nou.</span>}
                                                                                     </div>
                                                                                </div>
                                                                                <div className='col-12 mt--10'>
                                                                                     <div className='rbt-form-group'>
                                                                                          <button 
                                                                                               type="submit"
                                                                                               className='rbt-btn btn-gradient'
                                                                                          >
                                                                                               <i className="feather-refresh-ccw"></i> Actualizeaza parola
                                                                                          </button>
                                                                                     </div>
                                                                                </div>
                                                                           </form>
                                                                      </div>

                                                                      <div
                                                                           className='tab-pane fade'
                                                                           id='social'
                                                                           role='tabpanel'
                                                                           aria-labelledby='social-tab'
                                                                      >
                                                                           <form
                                                                                onSubmit={handleSubmit(onSubmitSocials)}
                                                                                className='rbt-profile-row rbt-default-form row row--15'
                                                                           >
                                                                                <div className='col-12'>
                                                                                     <div className='rbt-form-group'>
                                                                                          <label htmlFor='facebook'>
                                                                                               <i className='feather-facebook'></i>{" "}
                                                                                               Facebook
                                                                                          </label>
                                                                                          <input
                                                                                               id='facebook'
                                                                                               type='text'
                                                                                               placeholder='https://facebook.com/'
                                                                                               defaultValue={facebook}
                                                                                               onChange={(e) =>
                                                                                                    setFacebook(
                                                                                                         e.target.value
                                                                                                    )
                                                                                               }
                                                                                          />
                                                                                     </div>
                                                                                </div>
                                                                                <div className='col-12'>
                                                                                     <div className='rbt-form-group'>
                                                                                          <label htmlFor='twitter'>
                                                                                               <i className='feather-twitter'></i>{" "}
                                                                                               Twitter
                                                                                          </label>
                                                                                          <input
                                                                                               id='twitter'
                                                                                               type='text'
                                                                                               placeholder='https://twitter.com/'
                                                                                               defaultValue={twitter}
                                                                                               onChange={(e) =>
                                                                                                    setTwitter(
                                                                                                         e.target.value
                                                                                                    )
                                                                                               }
                                                                                          />
                                                                                     </div>
                                                                                </div>
                                                                                <div className='col-12'>
                                                                                     <div className='rbt-form-group'>
                                                                                          <label htmlFor='linkedin'>
                                                                                               <i className='feather-linkedin'></i>{" "}
                                                                                               Linkedin
                                                                                          </label>
                                                                                          <input
                                                                                               id='linkedin'
                                                                                               type='text'
                                                                                               placeholder='https://linkedin.com/'
                                                                                               defaultValue={linkedin}
                                                                                               onChange={(e) =>
                                                                                                    setLinkedin(
                                                                                                         e.target.value
                                                                                                    )
                                                                                               }
                                                                                          />
                                                                                     </div>
                                                                                </div>
                                                                                <div className='col-12'>
                                                                                     <div className='rbt-form-group'>
                                                                                          <label htmlFor='github'>
                                                                                               <i className='feather-github'></i>{" "}
                                                                                               Github
                                                                                          </label>
                                                                                          <input
                                                                                               id='github'
                                                                                               type='text'
                                                                                               placeholder='https://github.com/'
                                                                                               defaultValue={github}
                                                                                               onChange={(e) =>
                                                                                                    setGithub(
                                                                                                         e.target.value
                                                                                                    )
                                                                                               }
                                                                                          />
                                                                                     </div>
                                                                                </div>
                                                                                <div className='col-12 mt--10'>
                                                                                     <div className='rbt-form-group'>
                                                                                          <button
                                                                                               type="submit"
                                                                                               className='rbt-btn btn-gradient'
                                                                                          >
                                                                                               <i className="feather-refresh-ccw"></i> Actualizeaza link-urile
                                                                                          </button>
                                                                                     </div>
                                                                                </div>
                                                                           </form>
                                                                      </div>
                                                                 </div>
                                                            </div>
                                                       </div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>


		</>
	);
};

export default StudentSetting;
