// React 
import React, {useEffect, useState} from 'react'; 
import { useRouter } from 'next/router'; 
import Head from 'next/head'; 

// Utils
import { userService } from '@/services/user.service'; 
import { fetchWrapper } from '@/helpers/fetch-wrapper';

// Components 
import StudentDashboardSidebar from "@/components/Student/StudentDashboardSidebar";

import { format, parseISO } from 'date-fns';

const StudentStory = () => {
     const user = userService.userValue ? (true):(false);

     const router = useRouter(); 

     const [userOrders, setUserOrders] = useState([]); 

     useEffect(() => {

          if(user) {
               async function fetchUserOrders() {
                    const response = await fetchWrapper.get(`/api/users/getorders`);

                    setUserOrders(response[0].userOrders); 
               };
               fetchUserOrders();
          } 
          else router.push('/autentificare');
          
     }, []);

	return (
		<>
               <Head>
                    <meta name="robots" content="noindex, nofollow"/>  
                    <title>Profilul meu - Istoric Comenzi</title>
               </Head>

			<div className='rbt-page-banner-wrapper'>
				<div className='rbt-banner-image' />
			</div>
			<div className='rbt-dashboard-area rbt-section-overlayping-top rbt-section-gapBottom'>
				<div className='container'>
					<div className='row'>
						<div className='col-lg-12'>
							<div className='row g-5'>
								<div className='col-lg-3'>
									<StudentDashboardSidebar />
								</div>

								<div className='col-lg-9'>
                                             <div className='rbt-dashboard-content bg-color-white rbt-shadow-box'>
                                                  <div className='content'>
                                                       <div className='section-title'>
                                                            <h4 className='rbt-title-style-3'>
                                                                 <i className="feather-shopping-bag"></i> Istoric Comenzi
                                                            </h4>
                                                       </div>

                                                       <div className='rbt-dashboard-table table-responsive mobile-table-750'>
                                                            <table className='rbt-table table table-borderless'>
                                                                 <thead>
                                                                      <tr>
                                                                           <th>#ID</th>
                                                                           <th>Numele cursului</th>
                                                                           <th>Data</th>
                                                                           <th>Pret</th>
                                                                           <th>Status</th>
                                                                      </tr>
                                                                 </thead>

                                                                 <tbody>
                                                                      {userOrders.length > 0 ? (
                                                                           <>
                                                                                {userOrders.map((order, index) => (
                                                                                     <tr key={index}>
                                                                                          <th>#{order.id}</th>
                                                                                          <td>{order.courseName}</td>
                                                                                          <td>{format(parseISO(order.createdAt), 'yyyy-MM-dd HH:mm:ss')}</td>
                                                                                          <td>{order.price} RON </td>
                                                                                          <td>
                                                                                               <span className='rbt-badge-5 bg-color-success-opacity color-success'>
                                                                                                    Confirmata
                                                                                               </span>
                                                                                          </td>
                                                                                     </tr>
                                                                                ))}
                                                                           </>
                                                                      ): (
                                                                           <p>Nu exista date disponibile.</p>
                                                                      )}
                                                                 </tbody>
                                                            </table>
                                                       </div>
                                                  </div>
                                             </div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</>
	);
};

export default StudentStory;
