import React, {useEffect, useState} from 'react';
import Head from 'next/head'; 
import { useRouter } from 'next/router'; 

// Utils
import { userService } from '@/services/user.service'; 
import { fetchWrapper } from '@/helpers/fetch-wrapper'; 

import StudentDashboardHeader from "@/components/Student/StudentDashboardHeader";
import StudentDashboardSidebar from "@/components/Student/StudentDashboardSidebar";

import CounterWidget from "@/components/Instructor/Dashboard-Section/widgets/CounterWidget";

const ProfilStudent = () => {
     const user = userService.userValue ? (true):(false);

     const router = useRouter(); 

     const [userData, setUserData] = useState([]); 
     const [boughtCourses, setBoughtCourses] = useState(0); 
     const [completedCourses, setCompletedCourses] = useState(0); 
     const [uncompletedCourses, setUncompletedCourses] = useState(0); 

     useEffect(() => {

          if(user) {
               async function fetchUserData() {
                    const response = await fetchWrapper.get(`/api/users/getdata`);
                    const response2 = await fetchWrapper.get('/api/users/getstudentcourses'); 
                    setUserData(response[0].userData); 
                    setBoughtCourses(response2.boughtCourses); 
                    setCompletedCourses(response2.completedCourses);
                    setUncompletedCourses(response2.uncompletedCourses); 

                    if(response[0].userData.accountType == 1) {
                         router.replace('/'); 
                    }
               };
               fetchUserData();
          } 
          else router.push('/autentificare');
          
     }, []);

     return (
          <>
               <Head>
                    <meta name="robots" content="noindex, nofollow"/>  
                    <title>Profilul meu</title>
               </Head>

               <div className='rbt-page-banner-wrapper'>
				<div className='rbt-banner-image' />
			</div>
			<div className='rbt-dashboard-area rbt-section-overlayping-top rbt-section-gapBottom'>
				<div className='container'>
					<div className='row'>
						<div className='col-lg-12'>
                                   <StudentDashboardHeader userData={userData}/>

							<div className='row g-5'>
								<div className='col-lg-3'>
									<StudentDashboardSidebar />
								</div>

								<div className='col-lg-9'>
									<div className='rbt-dashboard-content bg-color-white rbt-shadow-box mb--60'>
										<div className='content'>
											<div className='section-title'>
												<h4 className='rbt-title-style-3'>
													Dashboard
												</h4>
											</div>
											<div className='row g-5'>
												<div className='col-lg-4 col-md-4 col-sm-6 col-12'>
													<CounterWidget
														counterStyle='two'
														styleClass='bg-primary-opacity'
														iconClass='bg-primary-opacity'
														numberClass='color-primary'
														icon='feather-book-open'
														title='Cursuri cumparate'
														value={boughtCourses}
													/>
												</div>
												<div className='col-lg-4 col-md-4 col-sm-6 col-12'>
													<CounterWidget
														counterStyle='two'
														styleClass='bg-secondary-opacity'
														iconClass='bg-secondary-opacity'
														numberClass='color-secondary'
														icon='feather-monitor'
														title='Cursuri nefinalizate'
														value={uncompletedCourses}
													/>
												</div>
												<div className='col-lg-4 col-md-4 col-sm-6 col-12'>
													<CounterWidget
														counterStyle='two'
														styleClass='bg-violet-opacity'
														iconClass='bg-violet-opacity'
														numberClass='color-violet'
														icon='feather-award'
														title='Cursuri completate'
														value={completedCourses}
													/>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
          </>
     );
};

export default ProfilStudent;