import React, { useEffect, useState } from "react";
import sal from "sal.js";
import Head from 'next/head';

// Components 
import StudentDashboardSidebar from "@/components/Student/StudentDashboardSidebar";
import Card from "@/components/Cards/Card";

// Utils 
import { userService } from "@/services/user.service";
import { fetchWrapper } from "@/helpers/fetch-wrapper";
import { useRouter } from "next/router";

const Favorite = () => {
     const [favoritesAds, setFavoritesAds] = useState([]);
     const [userSavedAds, setUserSavedAds] = useState([]);
     const router = useRouter(); 

	useEffect(() => {
		sal({
			threshold: 0.01,
			once: true,
		});
          
          const user = userService.userValue;

		if (user) {
               const fetchUserSavedAds = async () => {
				try {
					const response = await fetchWrapper.get('/api/savedProducts'); 
                         setFavoritesAds(response.favoritesAds);
                         setUserSavedAds(response.savedads);
				} catch (error) {
					console.error("Error fetching user saved ads:", error);
				}
			};

               fetchUserSavedAds(); 
          }
          else return router.replace('/'); 

	}, []);

	return (
		<>
               <Head>
                    <meta name="robots" content="noindex, nofollow"/>  
                    <title>Profilul Meu - Favorite</title>
               </Head>

			<div className='rbt-page-banner-wrapper'>
				<div className='rbt-banner-image' />
			</div>
			<div className='rbt-dashboard-area rbt-section-overlayping-top rbt-section-gapBottom'>
				<div className='container'>
					<div className='row'>
						<div className='col-lg-12'>
							<div className='row g-5'>
								<div className='col-lg-3'>
									<StudentDashboardSidebar />
								</div>

								<div className='col-lg-9'>
									<div className='rbt-dashboard-content bg-color-white rbt-shadow-box'>
										<div className='content'>
											<div className='section-title'>
												<h4 className='rbt-title-style-3'>
													<i className='feather-bookmark'></i>{" "}
													Lista de dorinte
												</h4>
											</div>
											<div className='row g-5'>
												{favoritesAds.length > 0 ? (
													<Card
														col='col-lg-4 col-md-6 col-sm-12 col-12'
														mt=''
														start={0}
														end={6}
														isDesc={true}
														isUser={true}
														lastCourses={favoritesAds}
														userSavedAds={userSavedAds}
                                                                      withSal={false}
													/>
												) : (
													<p>Lista de favorite este goala.</p>
												)}
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</>
	);
};

export default Favorite;
