// React 
import React, { useState, useEffect } from 'react'; 
import Link from 'next/link'; 
import { useRouter } from 'next/router';
import Head from 'next/head';

// Utils
import { userService } from '@/services/user.service'; 
import { fetchWrapper } from '@/helpers/fetch-wrapper'; 

// Components 
import StudentDashboardSidebar from "@/components/Student/StudentDashboardSidebar";

const StudentCourse = () => {
     const user = userService.userValue ? (true):(false);
     const router = useRouter(); 
     const [userData, setUserData] = useState([]); 
     const [uncompletedCourses, setUncompletedCourses] = useState([]); 
     const [completedCourses, setCompletedCourses] = useState([]); 

     useEffect(() => {

          if(user) {
               async function fetchUserData() {
                    const response = await fetchWrapper.get(`/api/users/getdata`);
                    setUserData(response[0].userData); 

                    const response2 = await fetchWrapper.get('/api/users/courses_progress');
                    setUncompletedCourses(response2.uncompletedCourses);  
                    setCompletedCourses(response2.completedCourses); 
               };
               fetchUserData();
          } 
          else router.push('/autentificare');
          
     }, []);

     return (
		<>
               <Head>
                    <meta name="robots" content="noindex, nofollow"/>  
                    <title>Profilul meu - Cursuri Inscrise</title>
               </Head>

               <div className='rbt-page-banner-wrapper'>
                    <div className='rbt-banner-image' />
               </div>
               <div className='rbt-dashboard-area rbt-section-overlayping-top rbt-section-gapBottom'>
                    <div className='container'>
                         <div className='row'>
                              <div className='col-lg-12'>

                                   <div className='row g-5'>
                                        <div className='col-lg-3'>
                                             <StudentDashboardSidebar />
                                        </div>

                                        <div className='col-lg-9'>
                                             <div className='rbt-dashboard-content bg-color-white rbt-shadow-box'>
                                                  <div className='content'>
                                                       <div className='section-title'>
                                                            <h4 className='rbt-title-style-3'>
                                                                 <i className="feather feather-book"/> Cursurile mele
                                                            </h4>
                                                       </div>
                                                       <div className='advance-tab-button mb--30'>
                                                            <ul
                                                                 className='nav nav-tabs tab-button-style-2 justify-content-start'
                                                                 id='myTab-4'
                                                                 role='tablist'
                                                            >
                                                                 <li role='presentation'>
                                                                      <Link
                                                                           href='#'
                                                                           className='tab-button active'
                                                                           id='home-tab-4'
                                                                           data-bs-toggle='tab'
                                                                           data-bs-target='#home-4'
                                                                           role='tab'
                                                                           aria-controls='home-4'
                                                                           aria-selected='true'
                                                                      >
                                                                           <span className='title'>
                                                                                <i className="feather feather-book-open"/> Necompletate
                                                                           </span>
                                                                      </Link>
                                                                 </li>
                                                                 
                                                                 <li role='presentation'>
                                                                      <Link
                                                                           href='#'
                                                                           className='tab-button'
                                                                           id='contact-tab-4'
                                                                           data-bs-toggle='tab'
                                                                           data-bs-target='#contact-4'
                                                                           role='tab'
                                                                           aria-controls='contact-4'
                                                                           aria-selected='false'
                                                                      >
                                                                           <span className='title'>
                                                                                <i className="feather feather-book"/>  Completate
                                                                           </span>
                                                                      </Link>
                                                                 </li>
                                                            </ul>
                                                       </div>

                                                       <div className='tab-content'>
                                                            <div
                                                                 className='tab-pane fade active show'
                                                                 id='home-4'
                                                                 role='tabpanel'
                                                                 aria-labelledby='home-tab-4'
                                                            >
                                                                 <div className='row g-5'>

                                                                      <div className='rbt-dashboard-table table-responsive mobile-table-750'>
                                                                           <table className='rbt-table table table-borderless'>
                                                                                <thead>
                                                                                     <tr>
                                                                                          <th>Nume</th>
                                                                                          <th>Progres</th>
                                                                                          <th>Intalnire zoom</th>
                                                                                          <th>Actiuni</th>
                                                                                     </tr>
                                                                                </thead>

                                                                                <tbody>
                                                                                     {uncompletedCourses.map((course, index) => (
                                                                                          <tr key={index}>
                                                                                               <td>{course.courseName}</td>
                                                                                               <td>
                                                                                               <h6 className="rbt-title-style-2 mb--10">{course.completionPercentage.toFixed(0)}%</h6>
                                                                                                    <div className="progress">
                                                                                                         <div
                                                                                                              className="progress-bar wow fadeInLeft bar-color-success"
                                                                                                              data-wow-duration="0.5s"
                                                                                                              data-wow-delay=".3s"
                                                                                                              role="progressbar"
                                                                                                              style={{ width: course.completionPercentage }}
                                                                                                              aria-valuenow={course.completionPercentage}
                                                                                                              aria-valuemin={0}
                                                                                                              aria-valuemax={100}
                                                                                                         ></div>
                                                                                                         
                                                                                                    </div>     
                                                                                               </td>  
                                                                                               <td style={{ color: 'red' }}>Momentan indisponibil</td>
                                                                                               <td>
                                                                                                    <Link href={"/curs/" + course.courseID}>
                                                                                                         <button className="btn btn-success"><i className="feather feather-eye"/> Acceseaza</button>
                                                                                                    </Link>
                                                                                               </td>  
                                                                                          </tr>
                                                                                     ))}
                                                                                </tbody>
                                                                           </table>
                                                                      </div>
                                                                      
                                                                 </div>
                                                            </div>

                                                            <div
                                                                 className='tab-pane fade'
                                                                 id='contact-4'
                                                                 role='tabpanel'
                                                                 aria-labelledby='contact-tab-4'
                                                            >
                                                                 <div className='row g-5'>
                                                                      <div className='rbt-dashboard-table table-responsive mobile-table-750'>
                                                                           <table className='rbt-table table table-borderless'>
                                                                                <thead>
                                                                                     <tr>
                                                                                          <th>Nume</th>
                                                                                          <th>Progres</th>
                                                                                          <th>Intalnire zoom</th>
                                                                                          <th>Actiuni</th>
                                                                                     </tr>
                                                                                </thead>

                                                                                <tbody>
                                                                                     {completedCourses.map((course, index) => (
                                                                                          <tr key={index}>
                                                                                               <td>{course.courseName}</td>
                                                                                               <td>
                                                                                               <h6 className="rbt-title-style-2 mb--10">{course.completionPercentage.toFixed(0)}%</h6>
                                                                                                    <div className="progress">
                                                                                                         <div
                                                                                                              className="progress-bar wow fadeInLeft bar-color-success"
                                                                                                              data-wow-duration="0.5s"
                                                                                                              data-wow-delay=".3s"
                                                                                                              role="progressbar"
                                                                                                              style={{ width: course.completionPercentage+'px' }}
                                                                                                              aria-valuenow={course.completionPercentage}
                                                                                                              aria-valuemin={0}
                                                                                                              aria-valuemax={100}
                                                                                                         ></div>
                                                                                                         
                                                                                                    </div>     
                                                                                               </td>  
                                                                                               <td style={{ color: 'red' }}>Momentan indisponibil</td>
                                                                                               <td>
                                                                                                    <Link href={"/curs/" + course.courseID}>
                                                                                                         <button className="btn btn-success"><i className="feather feather-eye"/> Acceseaza</button>
                                                                                                    </Link>
                                                                                               </td>  
                                                                                          </tr>
                                                                                     ))}
                                                                                </tbody>
                                                                           </table>
                                                                      </div>
                                                                 </div>
                                                            </div>
                                                       </div>
                                                  </div>
                                             </div>
                                        </div>
                                        
                                   </div>
                              </div>
                         </div>
                    </div>
               </div>
		</>
	);
};

export default StudentCourse;
