import React, {useEffect, useState} from 'react';
import Link from 'next/link'; 
import { useRouter } from 'next/router'; 
import Head from 'next/head';

// Utils
import { userService } from '@/services/user.service'; 
import { fetchWrapper } from '@/helpers/fetch-wrapper'; 

// Components 
import StudentDashboardHeader from "@/components/Student/StudentDashboardHeader";
import CounterWidget from "@/components/Instructor/Dashboard-Section/widgets/CounterWidget";

import Swal from 'sweetalert2'; 
import InstructorSidebar from '@/components/InstructorSidebar';

const ProfilStudent = () => {
     const user = userService.userValue ? (true):(false);

     const router = useRouter(); 

     const [userData, setUserData] = useState([]); 
     const [totalCourses, setTotalCourses] = useState(0); 
     const [totalStudents, setTotalStudents] = useState(0); 
     const [totalEarnings, setTotalEarnings] = useState(0); 
     const [coursesTable, setCoursesTable] = useState([]); 

     useEffect(() => {

          if(user) {
               async function fetchUserData() {
                    const response = await fetchWrapper.get(`/api/users/getdata`);
                    const response2 = await fetchWrapper.get('/api/users/getinstructorstats'); 
                    setUserData(response[0].userData); 
                    setTotalCourses(response2.totalCourses); 
                    setTotalStudents(response2.totalStudents);
                    setTotalEarnings(response2.totalEarnings); 
                    setCoursesTable(response2.coursesTable); 

                    if(response[0].userData.accountType == 0) {
                         router.replace('/'); 
                    }
               };
               fetchUserData();
          } 
          else router.push('/autentificare');
          
     }, []);

     const showReviews = (reviewsData) => {
          const reviewsHTML = reviewsData.map(review => `
               <style>
               .reviews-container {
                    max-height: 400px; 
                    overflow-y: auto;
                    padding: 1px;
                    background-color: #f9f9f9;
                    border-radius: 10px;
               }
               .review-item {
                    margin-bottom: 15px;
                    border-top: 1px solid black;
               }
               .rating2 {
                    color: #FFA500;
                    font-size: 25px;
               }
               .rating i {
                    margin-right: 2px;
               }
                    .author {
                         margin-top:10px;
                    }
               </style>
               
               <div class="review-item">
                    
                    <div class="rating2">
                         ${review.reviewBy}<br/>
                         ${'★'.repeat(review.reviewStars)}${'☆'.repeat(5 - review.reviewStars)}
                    </div>
                    <p>${review.reviewText}</p>
               </div>
          `).join('');
      
          Swal.fire({
               title: 'Recenzii',
               html: `
                    <div class="reviews-container">
                         ${reviewsHTML}
                    </div>
               `,
               showCloseButton: true,
               width: '600px',
               customClass: {
                    popup: 'swal-popup-reviews'
               }
          });
     };
      

     return (
          <>
               <Head>
                    <meta name="robots" content="noindex, nofollow"/>  
                    <title>Profilul Meu</title>
               </Head>

               <div className='rbt-page-banner-wrapper'>
				<div className='rbt-banner-image' />
			</div>
			<div className='rbt-dashboard-area rbt-section-overlayping-top rbt-section-gapBottom'>
				<div className='container'>
					<div className='row'>
						<div className='col-lg-12'>
                                   <StudentDashboardHeader userData={userData}/>

							<div className='row g-5'>
								<div className='col-lg-3'>
                                             <InstructorSidebar/> 
								</div>

								<div className='col-lg-9'>
									<div className='rbt-dashboard-content bg-color-white rbt-shadow-box mb--60'>
										<div className='content'>
											<div className='section-title'>
												<h4 className='rbt-title-style-3'>
													Dashboard
												</h4>
											</div>
											<div className='row g-5'>
												<div className='col-lg-4 col-md-4 col-sm-6 col-12'>
													<CounterWidget
														counterStyle='two'
														styleClass='bg-pink-opacity'
														iconClass='bg-pink-opacity'
														numberClass='color-pink'
														icon='feather-users'
														title='Total studenti'
														value={totalStudents}
													/>
												</div>
												<div className='col-lg-4 col-md-4 col-sm-6 col-12'>
													<CounterWidget
														counterStyle='two'
														styleClass='bg-coral-opacity'
														iconClass='bg-coral-opacity'
														numberClass='color-coral'
														icon='feather-book'
														title='Total cursuri'
														value={totalCourses}
													/>
												</div>
												<div className='col-lg-4 col-md-4 col-sm-6 col-12'>
													<CounterWidget
														counterStyle='two'
														styleClass='bg-warning-opacity'
														iconClass='bg-warning-opacity'
														numberClass='color-warning'
														icon='feather-dollar-sign'
														title='Venituri totale'
														value={totalEarnings}
													/>
												</div>
											</div>
										</div>
									</div>

                                             <div className="rbt-dashboard-content bg-color-white rbt-shadow-box mb--60">
                                                  <div className="content">
                                                       <div className="row">
                                                            <div className="col-lg-12">
                                                                 <div className="section-title">
                                                                      <h4 className="rbt-title-style-3"><i className="feather-book"/> Cursurile mele</h4>

                                                                      <div className="rbt-dashboard-table table-responsive">
                                                                           <table className="rbt-table table table-borderless">
                                                                                <thead>
                                                                                     <tr>
                                                                                          <th>Numele cursului</th>
                                                                                          <th>Studenti inscrisi</th>
                                                                                          <th>Recenzii</th>
                                                                                          <th>Actiuni</th>
                                                                                     </tr>
                                                                                </thead>

                                                                                <tbody>
                                                                                     {coursesTable.map((course, index) => (
                                                                                          <tr key={index}>
                                                                                               <th>
                                                                                                    <Link href={course.url}>{course.title}</Link>
                                                                                               </th>
                                                                                               <td>{course.students}</td>
                                                                                               <td>
                                                                                                    <div className="rating">                                                                                                                                {Array.from({ length: Math.floor(course.averageStars) }, (_, i) => (
                                                                                                         <i key={i} className="fas fa-star"></i>
                                                                                                    ))}
                                                                                                    </div>                      
                                                                                               </td>
                                                                                               <td><Link href="#" onClick={() => showReviews(course.reviews)}><i className="feather-eye"/> Vezi recenziile</Link></td>
                                                                                          </tr>
                                                                                     ))}
                                                                                </tbody>
                                                                           </table>
                                                                      </div>

                                                                 </div>
                                                            </div>
                                                       </div>
                                                  </div>
                                             </div>

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
          </>
     );
};

export default ProfilStudent;