// React 
import React, {useEffect, useState} from 'react'; 
import { useRouter } from 'next/router'; 
import Head from 'next/head'; 

// Utils
import { userService } from '@/services/user.service'; 
import { fetchWrapper } from '@/helpers/fetch-wrapper'; 

// Components 
import StudentDashboardHeader from "@/components/Student/StudentDashboardHeader";
import InstructorSidebar from '@/components/InstructorSidebar';

const Date = () => {
     const user = userService.userValue ? (true):(false);

     const router = useRouter(); 

     const [userData, setUserData] = useState([]); 

     useEffect(() => {

          if(user) {
               async function fetchUserData() {
                    const response = await fetchWrapper.get(`/api/users/getdata`);

                    setUserData(response[0].userData); 

                    if(response[0].userData.accountType == 0) {
                         router.replace('/'); 
                    }
               };
               fetchUserData();
          } 
          else router.push('/autentificare');
          
     }, []);

	return (
		<>   
               <Head>
                    <meta name="robots" content="noindex, nofollow"/>  
                    <title>Profilul Meu - Date</title>
               </Head>

			<div className='rbt-page-banner-wrapper'>
				<div className='rbt-banner-image' />
			</div>
			<div className='rbt-dashboard-area rbt-section-overlayping-top rbt-section-gapBottom'>
				<div className='container'>
					<div className='row'>
						<div className='col-lg-12'>
							<StudentDashboardHeader userData={userData}/>

							<div className='row g-5'>
								<div className='col-lg-3'>
                                             <InstructorSidebar/> 
								</div>

								<div className='col-lg-9'>
									<div className='rbt-dashboard-content bg-color-white rbt-shadow-box'>
										<div className='content'>
											<div className='section-title'>
												<h4 className='rbt-title-style-3'>
													Profilul meu
												</h4>
											</div>
											<div className='rbt-profile-row row row--15'>
												<div className='col-lg-4 col-md-4'>
													<div className='rbt-profile-content b2'>
														Data inregistrarii
													</div>
												</div>
												<div className='col-lg-8 col-md-8'>
													<div className='rbt-profile-content b2'>
                                                                      {userData.createdAt}
													</div>
												</div>
											</div>
											<div className='rbt-profile-row row row--15 mt--15'>
												<div className='col-lg-4 col-md-4'>
													<div className='rbt-profile-content b2'>
														Nume de familie
													</div>
												</div>
												<div className='col-lg-8 col-md-8'>
													<div className='rbt-profile-content b2'>
														{userData.surName}
													</div>
												</div>
											</div>
											<div className='rbt-profile-row row row--15 mt--15'>
												<div className='col-lg-4 col-md-4'>
													<div className='rbt-profile-content b2'>
														Prenume
													</div>
												</div>
												<div className='col-lg-8 col-md-8'>
													<div className='rbt-profile-content b2'>
														{userData.firstName}
													</div>
												</div>
											</div>
											<div className='rbt-profile-row row row--15 mt--15'>
												<div className='col-lg-4 col-md-4'>
													<div className='rbt-profile-content b2'>
														Nume de utilizator
													</div>
												</div>
												<div className='col-lg-8 col-md-8'>
													<div className='rbt-profile-content b2'>
														{userData.userName}
													</div>
												</div>
											</div>
											<div className='rbt-profile-row row row--15 mt--15'>
												<div className='col-lg-4 col-md-4'>
													<div className='rbt-profile-content b2'>
														Email
													</div>
												</div>
												<div className='col-lg-8 col-md-8'>
													<div className='rbt-profile-content b2'>
														{userData.email}
													</div>
												</div>
											</div>
											<div className='rbt-profile-row row row--15 mt--15'>
												<div className='col-lg-4 col-md-4'>
													<div className='rbt-profile-content b2'>
                                                                      Numar de telefon
													</div>
												</div>
												<div className='col-lg-8 col-md-8'>
													<div className='rbt-profile-content b2'>
														{userData.phoneNumber}
													</div>
												</div>
											</div>
										
											<div className='rbt-profile-row row row--15 mt--15'>
												<div className='col-lg-4 col-md-4'>
													<div className='rbt-profile-content b2'>
														Biografie
													</div>
												</div>
												<div className='col-lg-8 col-md-8'>
													<div className='rbt-profile-content b2'>
														{userData.bio}
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</>
	);
};

export default Date;
