import { useRouter } from "next/router";
import { useEffect } from "react";
import Head from "next/head";
import sal from "sal.js";
import "sal.js/dist/sal.css";

// Import Utils
import { fetchWrapper } from "@/helpers/fetch-wrapper";

export default function PlacedOrder() {
	const router = useRouter();
	const { sessionId, userID } = router.query;

	useEffect(() => {
		if (!router.isReady || !sessionId || !userID) return;

		async function fetchUserData() {
			try {
				const response = await fetchWrapper.post(
					"/api/users/ordersuccess",
					{ sessionId, userID }
				);

				setTimeout(() => {
					router.replace(response.page);
				}, 3000);
			} catch (error) {
				console.error("Failed to fetch user data", error);
			}
		}

		fetchUserData();
	}, [router.isReady, sessionId, userID, router]);

	useEffect(() => {
		sal();
	}, []);

	return (
          <>
          <Head>
               <meta name="robots" content="noindex, nofollow"/>  
               <title>Felicitari ! Achizitie cu success.</title>
          </Head>

		<section className='section bg-grey-100'>
			<div className='container'>
				<div className='text-center'>
					<br></br>
					<h3 style={{ color: "#2ba47c" }}>
						Felicitari! Achizitia a fost completata cu success.
					</h3>
					
					
				</div>
			</div>
		</section>
          </>
	);
}
