import React from "react";
import Head from 'next/head'; 

import Link from 'next/link'; 

import { useState } from 'react'; 

import { useRouter } from 'next/router'; 
import { userService } from '@/services/user.service';

// Form Validation
import { useForm } from 'react-hook-form';

// Toast Notification 
import { toast } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';

const Inregistrare = () => {
     const router = useRouter(); 
     const user = (!userService.userValue) ? (false):(true); 

     const [accType, setAccType] = useState(0); 
     const [termsStatus, setTermsStatus] = useState(false);

     const { register, handleSubmit, formState: { errors }, watch } = useForm();

     if (user) {
		window.location.href = "/";
		return null;
	}

     const changeAccType = () => {
          const newAccType = (accType == 0) ? (1):(0); 
          setAccType(newAccType); 
     }

     const changeTerms = () => {
          setTermsStatus(!termsStatus); 
     };

     const onSubmit = async (data) => {
          if(!termsStatus)
               return toast.error('Trebuie sa fii de acord cu termenii si conditiile pentru a te putea inregistra.'); 

          data.accountType = accType;
          data.userURL = data.userName.toLowerCase().replace(/[^\p{L}]/gu, ''); 

          return userService.register(data)
               .then(() => {
                    router.push('/');
               })
               .catch(() => {
                    toast.error('Datele introduse nu sunt valide sau sunt folosite de un alt utilizator !');
               });
     };

	return (
          <>
          <Head>
               <meta name="robots" content="noindex, nofollow"/>  
               <title>Inregistrare - ImpactAcademy.Ro, cursuri online</title>
          </Head>

		<center>
			<div className='col-lg-6 mt--30'>
				<div className='rbt-contact-form contact-form-style-1 max-width-auto'>
					<h3 className='title'>Înregistrare</h3>
					<form className="max-width-auto" onSubmit={handleSubmit(onSubmit)}> 
						<div className='form-group'>
							<input
								name='email'
								type='email'
								placeholder='Adresa de email'
                                        {...register('email', { required: true, pattern: /^\S+@\S+$/i })} 
							/>
                                   {errors.email && <span className="error">Trebuie sa introduci o adresa de email valida.</span>}
							<span className='focus-border'></span>
						</div>

                              <div className='form-group'>
							<input
								name='surName'
								type='text'
								placeholder='Nume de familie'
                                        {...register('surName', { required: true })} 
							/>
                                   {errors.surName && <span className="error">Trebuie sa introduci numele de familie.</span>}
							<span className='focus-border'></span>
						</div>

                              <div className='form-group'>
							<input
								name='firstName'
								type='text'
								placeholder='Prenume'
                                        {...register('firstName', { required: true })} 
							/>
                                   {errors.firstName && <span className="error">Trebuie sa introduci prenumele tau.</span>}
							<span className='focus-border'></span>
						</div>

						<div className='form-group'>
							<input
								name='userName'
								type='text'
								placeholder='Nume de utilizator'
                                        {...register('userName', { required: true })} 
							/>
                                   {errors.userName && <span className="error">Trebuie sa introduci un nume de utilizator.</span>}
							<span className='focus-border'></span>
						</div>

						<div className='form-group'>
							<input
								name='password'
								type='password'
								placeholder='Parola'
                                        {...register('password', { required: true })} 
							/>
                                   {errors.password && <span className="error">Parola este necesara</span>}
							<span className='focus-border'></span>
						</div>

						<div className='form-group'>
							<input
								name='confirmpassword'
								type='password'
								placeholder='Confirma parola'
                                        {...register('confirmpassword', { required: true })} 
							/>
                                   {errors.confirmpassword && <span className="error">Confirmarea parolei este necesara.</span>}
							<span className='focus-border'></span>
						</div>

                              <label
                                   class='form-check-label'
                                   for='accountType'
                              >
                                   Doresti sa te inregistrezi cu un
                                   cont de <b>Profesor</b> ? Daca bifezi aceasta optiune, contul va fii creeat strict pentru profesori.{" "}
                              </label>

						<div className='form-check form-switch d-flex justify-content-center'>
                     
                                   <input
                                        className='form-check-input'
                                        type='checkbox'
                                        name="accountType"
                                        id="accountType"
                                        style={{ fontSize: 23 }}
                                        onChange={changeAccType}
                                   />

						</div>
                              <br/>
                              <hr></hr>
                              <label
                                   class='form-check-label'
                                   for='terms'
                              >
                                   Sunt de acord cu <Link href="/termeni-si-conditii">Termenii si conditiile</Link>
                              </label>

                              <div className='form-check form-switch d-flex justify-content-center'>
                     
                                   <input
                                        className='form-check-input'
                                        type='checkbox'
                                        name="terms"
                                        id="terms"
                                        style={{ fontSize: 23 }}
                                        onChange={changeTerms}
                                   />

                              </div>
                              <br/>

						<div className='form-submit-group'>
							<button
								type='submit'
								className='rbt-btn btn-md btn-gradient hover-icon-reverse w-100'
							>
								<span className='icon-reverse-wrapper'>
									<span className='btn-text'>
										Înregistreaza-te
									</span>
									<span className='btn-icon'>
										<i className='feather-arrow-right'></i>
									</span>
									<span className='btn-icon'>
										<i className='feather-arrow-right'></i>
									</span>
								</span>
							</button>
						</div>
					</form>
				</div>
			</div>
		</center>
          </>
	);
};

export default Inregistrare;
