import React, { useState } from "react";
import Link from "next/link";

import { userService } from "@/services/user.service";

// Form Validation
import { useForm } from "react-hook-form";

// Toast Notification
import { toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";

import Head from 'next/head'; 

const Autentificare = () => {
	const user = (!userService.userValue) ? (false):(true); 

	const {
		register,
		handleSubmit,
		formState: { errors },
	} = useForm();

	if (user) {
		window.location.href = "/";
		return null;
	}

	const onSubmit = async (data) => {
		const userEmail = data.email;
		const userPass = data.password;

		try {
			await userService.login(userEmail, userPass);
			window.location.href = "/";
		} catch (error) {
			toast.error(error);
		}
	};

	return (
		<>
                   
               <Head>
                    <meta name="robots" content="noindex, nofollow"/>  
                    <title>Autentificare - ImpactAcademy.Ro, Cursuri Online</title>
               </Head>

			<center>
				<div className='col-lg-6 mt--30'>
					<div className='rbt-contact-form contact-form-style-1 max-width-auto'>
						<h3 className='title'>Autentificare</h3>
						<form
							className='max-width-auto'
							onSubmit={handleSubmit(onSubmit)}
						>
							<div className='form-group'>
								<input
									name='email'
									type='text'
									placeholder='Email'
									{...register("email", {
										required: true,
										pattern: /^\S+@\S+$/i,
									})}
								/>
								{errors.email && (
									<span className='error'>
										Trebuie sa introduci o adresa
										de email valida.
									</span>
								)}
								<span className='focus-border'></span>
							</div>
							<div className='form-group'>
								<input
									name='password'
									type='password'
									placeholder='Parola'
                                             {...register('password', { required: true })} 
								/>
                                        {errors.password && <span className="error">Parola este necesara</span>}
								<span className='focus-border'></span>
							</div>

							<div className='row mb--30 d-flex justify-content-center'>
								<div className='col-lg-6'>
									<div className='rbt-lost-password d-flex justify-content-center'>
										<Link
											className='rbt-btn-link'
											href='#'
										>
											<i className="feather-lock"/> Ai uitat parola ? 
										</Link>
									</div>
								</div>
							</div>

                                   <div className='row mb--30 d-flex justify-content-center'>
								<div className='col-lg-6'>
									<div className='rbt-lost-password d-flex justify-content-center'>
										<Link
											className='rbt-btn-link'
											href='/inregistrare'
										>
											<i className="feather-plus"/> Inregistreaza-te acum ! 
										</Link>
									</div>
								</div>
							</div>

							<div className='form-submit-group'>
								<button
									type='submit'
									className='rbt-btn btn-md btn-gradient hover-icon-reverse w-100'
								>
									<span className='icon-reverse-wrapper'>
										<span className='btn-text'>
											Autentificare
										</span>
										<span className='btn-icon'>
											<i className='feather-arrow-right'></i>
										</span>
										<span className='btn-icon'>
											<i className='feather-arrow-right'></i>
										</span>
									</span>
								</button>
							</div>
						</form>
					</div>
				</div>
			</center>
		</>
	);
};

export default Autentificare;
