import { apiHandler, db } from '@/helpers/api';

export default apiHandler({
     post: updateProfileSettings
});

async function updateProfileSettings(req, res) {
     const userID = req.userID;
     const formData = req.body; 

     if(!db.initialized)
          await db.initialize(); 

     try {
          const userData = await db.User.findByPk(userID); 
          
          if (!userData) 
               return res.status(404).json({ error: 'Unknown!' });

          await db.User.update(
               {
               firstName: formData.firstName,
               surName: formData.surName, 
               phoneNumber: formData.phoneNumber,
               bio: formData.bio 
               },
               {
                    where: {
                         id: userData.id
                    },
                    limit: 1
               }
          );
          

          res.status(200).json({ message: "Setarile profilului au fost actualizate cu succes!", status: 200});
     } catch (error) {
         
          return res.status(500).json({ error: error });
     }
}