import { apiHandler, db } from '@/helpers/api';

export default apiHandler({
     get: getUserSavedAds,
     delete: deleteUserSavedAd,
     put: putUserSavedAd
});

async function getUserSavedAds(req, res) {
     const realUserID = req.userID;  // Real 

     const userSavedAds = await db.UserSavedAds.findAll({
          attributes: ['SavedAd'], 
          where: {
               UserID: realUserID,
          },
     });
     const savedAds = userSavedAds.map((ad) => ad.toJSON());

     res.status(200).json(savedAds);
}

async function deleteUserSavedAd(req, res) {

     await db.UserSavedAds.destroy({
          where: {
               UserID: req.userID, 
               SavedAd: req.query.itemID
          },
          limit: 1
     });

     res.status(200).json('Ai sters cu succes acest anunt din lista de favorite.'); 
}

async function putUserSavedAd(req, res) {
     await db.UserSavedAds.create({
          UserID: req.userID,
          SavedAd: req.query.itemID,
     }); 

     res.status(200).json('Ai adaugat cu success acest anunt in lista de favorite.'); 
}