import { apiHandler, db } from "@/helpers/api";
import { Op } from "sequelize";

export default apiHandler({
	get: getSavedAds,
});

async function getSavedAds(req, res) {
	if (!db.initialized) await db.initialize();

	const userID = req.userID;

	let favoritesAds = [];
	let savedAd = [];

	const savedAdsData = await db.UserSavedAds.findAll({
		attributes: ["SavedAd"],
		where: {
			UserID: userID,
		},
	});

	const savedAdIds = savedAdsData.map((savedAd) => savedAd.SavedAd);
	savedAd = savedAdIds;

     const adsData = await db.Courses.findAll({
          where: {
               id: {
                    [Op.in]: savedAdIds,
               },
          },
     });

     const serializedCourses = adsData.map((course) => ({
          ...course.toJSON(),
          createdAt: course.createdAt.toISOString(),
          updatedAt: course.updatedAt.toISOString(), 
     }));

     const lastCourses = await Promise.all(
          serializedCourses.map(async (course) => {
               const lessonsCount = await db.Modules.count({
                    where: {
                         type: "lesson",
                         courseID: course.id,
                    },
               });
               course.lessonCount = lessonsCount;

               const instructorData = await db.User.findOne({
                    attributes: ["avatar"],
                    where: {
                         id: course.instructorID,
                    },
                    limit: 1,
               });

               course.instructorAvatar = instructorData
                    ? instructorData.avatar
                    : null;

               return course;
          })
     );

	const response = {
		favoritesAds: lastCourses,
		savedads: savedAd,
	};

	res.json(response);
}
