import { db } from "@/helpers/api/db";

export default async function handler(req, res) {
	if (!db.initialized) {
		await db.initialize();
	}

	try {
          const getIndexReviews = await db.Reviews.findAll({
               attributes: ['reviewText', 'reviewByID', 'reviewBy'], 
               where: {
                    reviewStars: 5
               },
               limit: 14, 
               raw: true
          });
          
          const reviewsWithAvatars = await Promise.all(getIndexReviews.map(async (review) => {

               const user = await db.User.findOne({
                    attributes: ['avatar'], 
                    where: { id: review.reviewByID },
                    raw: true
               });
          
               return {
                    ...review,
                    avatar: user ? user.avatar : null 
               };
          }));
          

          const half = Math.ceil(reviewsWithAvatars.length / 2);
          const leftReviews = reviewsWithAvatars.slice(0, half);
          const rightReviews = reviewsWithAvatars.slice(half);
          
          return res.status(200).json({ left: leftReviews, right: rightReviews });

	} catch (error) {
		console.error("Error fetching categories:", error);
		return res
			.status(500)
			.json({ error: "Internal server error", status: 500 });
	}
}
