import React, {useEffect, useState} from 'react'; 
import Head from 'next/head'; 

import { useRouter } from 'next/router'; 

// Utils
import { userService } from '@/services/user.service'; 
import { fetchWrapper } from '@/helpers/fetch-wrapper'; 

import Link from 'next/link'; 
import Swal from 'sweetalert2'; 
import { toast } from 'react-toastify';

const AdminPage = () => {
     const user = userService.userValue ? (true):(false);

     const router = useRouter(); 

     const [userData, setUserData] = useState([]); 
     const [adminData, setAdminData] = useState([]); 
     const [adminUsers, setAdminUsers] = useState([]); 
     const [waitingCourses, setWaitingCourses] = useState([]); 

     async function loadAdminData(searchTerm) {
          const resp2 = await fetchWrapper.get('/api/users/admindata'); 
          setAdminData(resp2[0]);

          const resp3 = await fetchWrapper.get('/api/users/adminusers?searchTerm=' + searchTerm); 
          setAdminUsers(resp3[0].userList); 

          setWaitingCourses(resp3[0].coursesList); 
     }

     useEffect(() => {

          if(user) {

               async function fetchUserData() {
                    const response = await fetchWrapper.get(`/api/users/getdata`);

                    setUserData(response[0].userData); 

                    if(response[0].userData.admin == 0) {
                         router.replace('/'); 
                    }

                    loadAdminData(''); 
               };
               fetchUserData();
          } 
          else router.push('/autentificare');
          
     }, []);

     const handleEditUser = (userData) => {
          Swal.fire({
              title: 'Edit User Information',
               width:'600px', 
              html: `
                    <br/><label for="swal-input-email">Email:</label>
                    <br/>
                    <input type="email" id="swal-input-email" class="swal2-input" placeholder="Email" value="${userData.email}">
                    <br/><br/><label for="swal-input-userName">Nume de utilizator:</label><br/>
                    <input type="text" id="swal-input-userName" class="swal2-input" placeholder="Nume de utilizator" value="${userData.userName}">
                    <br/><br/><label for="swal-input-surName">Prenume:</label><br/>
                    <input type="text" id="swal-input-surName" class="swal2-input" placeholder="Prenume" value="${userData.surName}">
                    <br/><br/><label for="swal-input-firstName">Nume:</label><br/>
                    <input type="text" id="swal-input-firstName" class="swal2-input" placeholder="Nume" value="${userData.firstName}">
                    <br/><br/><label for="swal-input-bio">Biografie:</label>
                    <br/>
                    <textarea id="swal-input-bio" class="swal2-textarea" placeholder="Bio">${userData.bio}</textarea>
                    <br/><br/><label for="swal-input-phoneNumber">Numar de telefon:</label><br/>
                    <input type="text" id="swal-input-phoneNumber" class="swal2-input" placeholder="Numar de telefon" value="${userData.phoneNumber}">
                    <br/><br/><label for="swal-input-facebook">Facebook:</label><br/>
                    <input type="text" id="swal-input-facebook" class="swal2-input" placeholder="Facebook" value="${userData.facebook}">
                    <br/><br/><label for="swal-input-twitter">Twitter:</label><br/>
                    <input type="text" id="swal-input-twitter" class="swal2-input" placeholder="Twitter" value="${userData.twitter}">
                    <br/><br/><label for="swal-input-github">GitHub:</label><br/>
                    <input type="text" id="swal-input-github" class="swal2-input" placeholder="GitHub" value="${userData.github}">
                    <br/><br/><label for="swal-input-linkedin">LinkedIn:</label><br/>
                    <input type="text" id="swal-input-linkedin" class="swal2-input" placeholder="LinkedIn" value="${userData.linkedin}">
              `,
              focusConfirm: false,
              showCancelButton: true,
              confirmButtonText: 'Salveaza',
              cancelButtonText: 'Renunta',
              preConfirm: () => {
                  return {
                      email: document.getElementById('swal-input-email').value,
                      userName: document.getElementById('swal-input-userName').value,
                      surName: document.getElementById('swal-input-surName').value,
                      firstName: document.getElementById('swal-input-firstName').value,
                      bio: document.getElementById('swal-input-bio').value,
                      phoneNumber: document.getElementById('swal-input-phoneNumber').value,
                      facebook: document.getElementById('swal-input-facebook').value,
                      twitter: document.getElementById('swal-input-twitter').value,
                      github: document.getElementById('swal-input-github').value,
                      linkedin: document.getElementById('swal-input-linkedin').value
                  };
              }
          }).then(async (result) => {
               if (result.isConfirmed) {
                    const updatedData = result.value;
                    
                    await fetchWrapper.post('/api/users/admindata', {updatedData, userUpdatedID: userData.id }); 

                    toast.success('Datele acestui utilizator au fost actualizate cu succes!');
                    loadAdminData('');
               }
          });
      };

     const handleDeleteUser = (userDeleteID) => {
          Swal.fire({
               title: 'Esti sigur ca vrei sa stergi acest utilizator?',
               icon: 'warning',
               iconHtml: '<i class="fa fa-trash"></i>',
               showCancelButton: true,
               confirmButtonText: 'Da',
               cancelButtonText: 'Nu',
               customClass: {
                    confirmButton: 'btn btn-danger',
                    cancelButton: 'btn btn-secondary'
               },
               buttonsStyling: false,
          }).then(async (result) => {
               if (result.isConfirmed) {
                    
                    await fetchWrapper.delete('/api/users/admindata', {userDeleteID}); 
                    loadAdminData(''); 
               }
          });
     };

     const handleCourseStatus = async (courseID) => {
          await fetchWrapper.post('/api/users/admincourse', { courseID }); 
          loadAdminData(''); 
          toast.success('Cursul a fost aprobat cu success !'); 
     }

     const handleDeleteCourse = (courseID) => {
          Swal.fire({
               title: 'Esti sigur ca vrei sa stergi acest curs ?',
               icon: 'warning',
               iconHtml: '<i class="fa fa-trash"></i>',
               showCancelButton: true,
               confirmButtonText: 'Da',
               cancelButtonText: 'Nu',
               customClass: {
                    confirmButton: 'btn btn-danger',
                    cancelButton: 'btn btn-secondary'
               },
               buttonsStyling: false,
          }).then(async (result) => {
               if (result.isConfirmed) {
                    
                    await fetchWrapper.delete('/api/users/admincourse', {courseID}); 
                    loadAdminData(''); 
               }
          });
     };

     const handleSearchChange = async (searchTerm) => {
          if(searchTerm.length >= 3) {
               loadAdminData(searchTerm); 
          }
          else loadAdminData('');
     };

	return (
          <>
  
               <Head>
                    <meta name="robots" content="noindex, nofollow"/>  
                    <title>Panou de administrare</title>
               </Head>

               <div className="container mt--30">
                    <div className="row g-12 align-items-center">
                         <div className="col-lg-3 col-md-6 col-sm-6 col-12">
                                <div className="rbt-counterup rbt-hover-03" style={{ borderTop: '8px solid lightblue' }}>
                                    <div className="inner">

                                        <div className="content">
                                            <h3 className="">{adminData.studentCount}
                                            </h3>
                                            <span className="subtitle"><b>Studenti Inregistrati</b></span>
                                        </div>
                                    </div>
                                </div>
                         </div>

                         <div className="col-lg-3 col-md-6 col-sm-6 col-12">
                                <div className="rbt-counterup rbt-hover-03" style={{ borderTop: '8px solid lightgreen' }}>
                                    <div className="inner">

                                        <div className="content">
                                             <h3 className="">{adminData.instructorCount}
                                             </h3>
                                            <span className="subtitle"><b>Profesori Inregistrati</b></span>
                                        </div>
                                    </div>
                                </div>
                         </div>

                         <div className="col-lg-3 col-md-6 col-sm-6 col-12">
                                <div className="rbt-counterup rbt-hover-03" style={{ borderTop: '8px solid orange' }}>
                                    <div className="inner">

                                        <div className="content">
                                            <h3 className="">{adminData.courseCount}
                                            </h3>
                                            <span className="subtitle"><b>Cursuri totale in platforma</b></span>
                                        </div>
                                    </div>
                                </div>
                         </div>

                         <div className="col-lg-3 col-md-6 col-sm-6 col-12">
                                <div className="rbt-counterup rbt-hover-03" style={{ borderTop: '8px solid yellow' }}>
                                    <div className="inner">

                                        <div className="content">
                                            <h3 className="">{adminData.courseCountWaiting}
                                            </h3>
                                            <span className="subtitle"><b>Cursuri ce necesita aprobare</b></span>
                                        </div>
                                    </div>
                                </div>
                         </div>
                         
                         <div className="advance-tab-button mb--30" style={{ marginTop: 60 }}>
                              <ul className="nav nav-tabs tab-button-style-2 justify-content-start" id="reviewTab-4" role="tablist">
                                   <li role="presentation">
                                        <a className="tab-button active" id="received-tab" data-bs-toggle="tab" data-bs-target="#received" role="tab" aria-controls="received" aria-selected="true" href="#">
                                             <span className="title"><i className="feather-user"/> Utilizatori</span>
                                        </a>
                                   </li>
                                   <li role="presentation">
                                        <a className="tab-button" id="given-tab" data-bs-toggle="tab" data-bs-target="#given" role="tab" aria-controls="given" aria-selected="false" href="#">
                                             <span className="title"><i className="feather-help-circle"/> Cursuri in asteptare</span>
                                        </a>
                                   </li>
                              </ul>
                         </div>

                         <div className="tab-content">
                              <div className="tab-pane fade active show" id="received" role="tabpanel" aria-labelledby="received-tab">
                                   <div className="rbt-dashboard-table table-responsive mobile-table-750">
                                        <center>
                                             <input id="search_term" name="search_term" type="search" placeholder="Cauta utilizator ..." onChange={(e) => handleSearchChange(e.target.value)}/>
                                             <br/>
                                             <small>
                                                  <p style={{color:'red'}}>(!)</p> Cautarea se poate efectua dupa email / username.
                                             </small>
                                        </center>
                                        <br/>
                                        <table className="rbt-table table table-borderless">
                                             <thead>
                                                  <tr>
                                                       <th>Rol</th>
                                                       <th>Nume utilizator</th>
                                                       <th>Nume</th>
                                                       <th>Prenume</th>
                                                       <th>Actiuni</th>
                                                  </tr>
                                             </thead>
                                             <tbody>
                                                  {adminUsers.map((user, index) => (
                                                       <tr key={index}>
                                                            <td>{user.accountType == 0 ? (<b style={{ color:'white', backgroundColor: 'lightblue' }}>STUDENT</b>) : (<b style={{ color:'white', backgroundColor:'green' }}>PROFESOR</b>)}</td>
                                                            <td>{user.userName}</td>
                                                            <td>{user.firstName}</td>
                                                            <td>{user.surName}</td>
                                                            <td>
                                                                 <div className="rbt-button-group">
                                                                      <Link className="rbt-btn-link left-icon" href="#" style={{ color: 'orange' }} onClick={() => handleEditUser(user)}>
                                                                            <i className="feather-edit"></i> Editeaza
                                                                      </Link>
                                                                      <Link className="rbt-btn-link left-icon" href="#" style={{ color: 'red' }} onClick={() => handleDeleteUser(user.id)}>
                                                                           <i className="feather-trash-2"></i> Sterge
                                                                      </Link>
                                                                 </div>
                                                            </td>
                                                       </tr>
                                                  ))}
                                             </tbody>
                                        </table>
                                   </div>
                              </div>

                              <div className="tab-pane fade active" id="given" role="tabpanel" aria-labelledby="given-tab">
                                   <div className="rbt-dashboard-table table-responsive mobile-table-750">

                                        <table className="rbt-table table table-borderless">
                                             <thead>
                                                  <tr>
                                                       <th>Nume curs</th>
                                                       <th>Nume instructor</th>
                                                       <th>Actiuni</th>
                                                  </tr>
                                             </thead>
                                             <tbody>
                                                  {waitingCourses.map((course, index) => (
                                                       <tr key={index}>
                                                            <td>
                                                                 <a href={`/${course.url}`} target="_blank" rel="noopener noreferrer">
                                                                      {course.title}
                                                                 </a>
                                                            </td>
                                                            <td>
                                                                 {course.instructorName}
                                                            </td>
                                                            <td>
                                                                 <div className="rbt-button-group">
                                                                      <Link className="rbt-btn-link left-icon" href="#" style={{ color: 'green' }} onClick={() => handleCourseStatus(course.id)}>
                                                                           <i className="feather-check"></i> Aproba postarea
                                                                      </Link>
                                                                      <Link className="rbt-btn-link left-icon" href="#" style={{ color: 'red' }} onClick={() => handleDeleteCourse(course.id)}>
                                                                           <i className="feather-trash-2"></i> Sterge
                                                                      </Link>
                                                                 </div>
                                                            </td>
                                                       </tr>
                                                  ))}
                                             </tbody>
                                        </table>
                                   </div>
                              </div>

                         </div>
                         
                    </div>
               </div>
          </>
     ); 
}
export default AdminPage;