import React, { useEffect } from "react";

import "bootstrap/scss/bootstrap.scss";

// ========= Plugins CSS START =========
import "../node_modules/sal.js/dist/sal.css";
import "../public/css/plugins/fontawesome.min.css";
import "../public/css/plugins/feather.css";
import "../public/css/plugins/odometer.css";
import "../public/css/plugins/animation.css";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/effect-cards";
import "swiper/css/free-mode";
import "swiper/css/thumbs";
// ========= Plugins CSS END =========

import sal from "sal.js";
import "../public/scss/styles.scss";

import Context from "@/context/Context";
import BackToTop from "@/pages/backToTop";
import HeaderStyleTen from "@/components/Header/HeaderStyle";
import MobileMenu from "@/components/Header/MobileMenu";
import { ToastContainer } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";
import FooterOne from "@/components/Footer/Footer-One";


export default function App({ Component, pageProps }) {
	useEffect(() => {
		require("bootstrap/dist/js/bootstrap.bundle.min.js");

		// sal({
		//   threshold: 0.01,
		//   once: true,
		// });
	}, []);
	return (
      
          <Context>
               <HeaderStyleTen headerSticky='rbt-sticky' headerType='' />
               <MobileMenu />
               <ToastContainer />
               <Component {...pageProps} />
               <BackToTop />
               <FooterOne />
          </Context>
  
	);
}
