import Link from 'next/link'; 
import Head from 'next/head'; 

const ErrorPage = () => {
	return (
          <>
               <Head>
                    <meta name="robots" content="noindex, nofollow"/>  
                    <title>Oops! Nu am putut gasi ceea ce cauti ...</title>
               </Head>
               <div className='rbt-error-area bg-gradient-11 rbt-section-gap'>
                    <div className='error-area'>
                         <div className='container'>
                              <div className='row justify-content-center text-center'>
                                   <div className='col-10'>
                                        <h1 className='title'>404!</h1>
                                        <h3 className='sub-title'>Pagina nu a fost gasita!</h3>
                                        <p>
                                             Pagina pe care o cauti nu a fost gasita.
                                        </p>
                                        <Link
                                             className='rbt-btn btn-gradient icon-hover'
                                             href='/'
                                        >
                                             <span className='btn-text'>
                                                  Inapoi acasa
                                             </span>
                                             <span className='btn-icon'>
                                                  <i className='feather-arrow-right'></i>
                                             </span>
                                        </Link>
                                   </div>
                              </div>
                         </div>
                    </div>
               </div>
          </>
     );
};

export default ErrorPage;
