import React, { createContext, useContext, useState, useEffect } from "react";

export const CreateContext = createContext();

export const useAppContext = () => useContext(CreateContext);

const Context = ({ children }) => {
	const [cartToggle, setCart] = useState(true);
	const [toggle, setToggle] = useState(true);
	const [search, setSearch] = useState(true);
	const [mobile, setMobile] = useState(true);
	const [smallMobileMenu, setsmallMobileMenu] = useState(true);
	const [pricing, setPricing] = useState(true);
	const [pricingTwo, setPricingTwo] = useState(true);
	const [pricingThree, setPricingThree] = useState(true);
	const [pricingFour, setPricingFour] = useState(true);

	return (
		<CreateContext.Provider
			value={{
				toggle,
				setToggle,
				mobile,
				setMobile,
				smallMobileMenu,
				setsmallMobileMenu,
				cartToggle,
				setCart,
				search,
				setSearch,
				pricing,
				setPricing,
				pricingTwo,
				setPricingTwo,
				pricingThree,
				setPricingThree,
				pricingFour,
				setPricingFour,
			}}
		>
			{children}
		</CreateContext.Provider>
	);
};

export default Context;
