import React, { useEffect, useState } from "react";
import Image from "next/image";
import { useRouter } from 'next/router'; 

// Utils
import { fetchWrapper } from "@/helpers/fetch-wrapper";
import img from "../../public/images/others/thumbnail-placeholder.svg";

// Toast Notification
import { toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";

// SweetAlert2
import Swal from "sweetalert2";
import withReactContent from "sweetalert2-react-content";
const MySwal = withReactContent(Swal);

// AWS Upload 
import AWS from 'aws-sdk';

// Form Validation
import { useForm } from 'react-hook-form';

const showModal = async (title, inputType, placeholder) => {
	const { value: inputValue } = await MySwal.fire({
		title,
		input: inputType,
		inputLabel: placeholder,
		inputPlaceholder: placeholder,
		showCancelButton: true,
		confirmButtonText: "Submit",
		cancelButtonText: "Cancel",
	});

	return inputValue;
};

const InfoForm = () => {
	const [categories, setCategories] = useState([]);
	const [selectedCategory, setSelectedCategory] = useState('Social');
     const [selectedSubcategory, setSelectedSubcategory] = useState('Dezvoltare personala'); 
     const [selectedChildrens, setSelectedChildrens] = useState('Gestionarea timpului'); 
	const [subcategories, setSubcategories] = useState([]);
     const [childrens, setChildrens] = useState([]); 
     
     const [courseLevel, setCourseLevel] = useState('Incepator'); 

	// Thumbnail
	const [selectedFile, setSelectedFile] = useState(null);
     const [originalPreview, setOriginalPreview] = useState(img); 
	const [preview, setPreview] = useState(img);
	const [videoFile, setVideoFile] = useState(null);
	const [videoPreview, setVideoPreview] = useState(null);

     const { register, handleSubmit, formState: { errors }, watch, setFocus } = useForm();

     const router = useRouter(); 

     AWS.config.update({
          accessKeyId: 'AKIA5GGKBZBER6MSVHEX',
          secretAccessKey: '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',
     });
  
     const s3 = new AWS.S3();

	const handlePreviewChange = async (event) => {
		const file = event.target.files[0];

		if (file) {
			const url = URL.createObjectURL(file);
			setVideoFile(file);
			setVideoPreview(url);

			const reader = new FileReader();
			reader.onloadend = () => {
				toast.success("Videoclipul a fost incarcat!");
                    return; 
			};
			reader.readAsDataURL(file);
		}
          return; 
	};

	const handleThumbnailChange = (event) => {
		const file = event.target.files[0];
		setSelectedFile(file);

		const reader = new FileReader();
		reader.onloadend = () => {
			setPreview(reader.result);
		};
		if (file) {
			reader.readAsDataURL(file);
			toast.success("Imaginea a fost incarcata!");
               return; 
		}
          return; 
	};

	useEffect(() => {
		const fetchCategories = async () => {
			try {
				const categResponse = await fetchWrapper.get(
					"/api/categories"
				);

				setCategories(categResponse.categories);
                    setSelectedCategory('Social'); 

				const subcategResponse = await fetchWrapper.get(
					"/api/subcategories/50"
				);
				setSubcategories(subcategResponse.subcategories);
                    setSelectedSubcategory('Dezvoltare personala'); 

                    const childrensResponse = await fetchWrapper.get(
                         "/api/filters/subchildrens/dezvoltare-personala"
                    );
                    setChildrens(childrensResponse.childrens);
                    setSelectedChildrens('Gestionarea timpului'); 

                    console.log(childrensResponse.childrens);
			} catch (err) {
				console.error("Failed to fetch categories", err);
			}
		};
		fetchCategories();
	}, []);

     const handleCourseLevel = (event) => setCourseLevel(event.target.value); 

	const handleCategoryChange = async (event) => {
		const parentID = event.target.value;
          const categoryName = event.target.options[event.target.selectedIndex].getAttribute('valueName');
		setSelectedCategory(categoryName);

		if (parentID) {
			try {
				const response = await fetchWrapper.get(
					"/api/subcategories/" + parentID
				);
				setSubcategories(response.subcategories || []);
                    setSelectedSubcategory(response.subcategories[0].url); 

                    const childs = await fetchWrapper.get(
                         "/api/filters/subchildrens/" + response.subcategories[0].url
                    );
                    if(childs) {
                         setChildrens(childs.childrens || []); 
                         setSelectedChildrens(childs.childrens[0].url);
                    }
                    alert(categoryName + "|" + response.subcategories[0].url + "|" + childs.childrens[0].url);
			} catch (err) {
				console.error("Failed to fetch subcategories", err);
			}
               

		} else {
			setSubcategories([]);
		}

          
	};

     const handleSubcategoryChange = async (event) => {
          const selectedName = event.target.value; 
      
          if(selectedName.length > 1) {
               try {
                    const childs = await fetchWrapper.get(
                         "/api/filters/subchildrens/" + selectedName
                    );
                    setChildrens(childs.childrens); 
                    setSelectedSubcategory(selectedName);
                    setSelectedChildrens(childs.childrens[0].url); 

                    alert(selectedCategory + " | " + selectedName + "| " + childs.childrens[0].url);
               } catch (err) {
                    console.error("Failed to fetch childs", err); 
               }
          } else setSelectedSubcategory(''); 
     };

     const handleChildrensChange = (event) => {
          const selectedName = event.target.value; 
          const selectedURL = event.target.options[event.target.selectedIndex].getAttribute('valueName');
          if(selectedName) {
               setSelectedChildrens(selectedURL); 
               alert(selectedCategory + " | " + selectedSubcategory + " | " + selectedURL); 
          }
          else {
               setSelectedChildrens(''); 
          }
     }

	/*
          Module & Capitole & Lectii Algo
     */

	const [modules, setModules] = useState([]);
	const [videoFiles, setVideoFiles] = useState({});
     
     // Q & A 
     const [questions, setQuestions] = useState({});

     const addQuestions = async (e, moduleId) => {
          e.preventDefault();

          if (questions[moduleId]?.length > 0) {
               // Dacă există întrebări, ștergem setul
               setQuestions((prev) => {
                   const updatedQuestions = { ...prev };
                   delete updatedQuestions[moduleId];
                   return updatedQuestions;
               });
               return; // Ieșim din funcție pentru că am șters întrebările
           }

          let newQuestions = [];
          for (let i = 1; i <= 5; i++) {
              const question = await MySwal.fire({
                    width:600,
                    title: `Intrebarea ${i}`,
                    input: "text",
                    inputLabel: "Introdu intrebarea",
                    inputPlaceholder: `Intrebarea ${i}`,
                    showCancelButton: true,
                    confirmButtonText: "Urmatorul",
                    cancelButtonText: "Anuleaza",
                    inputValidator: (value) => {
                         if (!value) {
                              return 'Trebuie să introduci o întrebare!';
                         }
                    }
              });
      
              if (question.isDismissed) return; // Stop if canceled
      
              let answers = [];
              let correctAnswerIndex = null;
      
              const answerInputs = await MySwal.fire({
               width:800, 
                  title: `Raspunsuri pentru Intrebarea ${i}`,
                  html: `
                      <div class="answer-input">
                          <input type="text" id="answer1" placeholder="Raspuns 1" class="swal2-input">
                          <input type="text" id="answer2" placeholder="Raspuns 2" class="swal2-input">
                          <input type="text" id="answer3" placeholder="Raspuns 3" class="swal2-input">
                      </div>
                      <label for="correctAnswerSelect" class="swal2-label">Care raspuns este corect?</label>
                      <select id="correctAnswerSelect" class="swal2-select">
                          <option value="0">Raspuns 1</option>
                          <option value="1">Raspuns 2</option>
                          <option value="2">Raspuns 3</option>
                      </select>
                  `,
                  focusConfirm: false,
                  
                  preConfirm: () => {
                      const answer1 = document.getElementById('answer1').value;
                      const answer2 = document.getElementById('answer2').value;
                      const answer3 = document.getElementById('answer3').value;
                      const correctAnswerIndex = document.getElementById('correctAnswerSelect').value;
      
                      if (!answer1 || !answer2 || !answer3) {
                          Swal.showValidationMessage('Toate raspunsurile trebuie completate!');
                          return null;
                      }
      
                      return {
                          answers: [answer1, answer2, answer3],
                          correctAnswerIndex: parseInt(correctAnswerIndex),
                      };
                  }
              });
      
              if (answerInputs.value) {
                  newQuestions.push({
                      question: question.value,
                      answers: answerInputs.value.answers,
                      correctAnswerIndex: answerInputs.value.correctAnswerIndex,
                  });
              } else {
                  return; // Stop if canceled or validation failed
              }
          }
      
          setQuestions((prev) => ({
              ...prev,
              [moduleId]: newQuestions
          }));
      
          console.log("Intrebari adaugate: ", newQuestions); // Debugging
      };
      

	const addModule = async () => {
		const title = await showModal(
			"Adauga Modul",
			"text",
			"Introdu titlul modulului"
		);
		if (title) {
			const newModule = { id: Date.now(), title, chapters: [] };
			setModules([...modules, newModule]);
               return; 
		}
          return; 
	};

	const addChapter = async (e, moduleId) => {
          e.preventDefault();
           
		const title = await showModal(
			"Adauga capitol",
			"text",
			"Introdu titlul capitolului"
		);
		if (title) {
			const newChapter = { id: Date.now(), title, lessons: [] };
			const updatedModules = modules.map((module) =>
				module.id === moduleId
					? {
							...module,
							chapters: [...module.chapters, newChapter],
					  }
					: module
			);
			setModules(updatedModules);
               return; 
		}
          return;
	};

     const addLesson = async (e, moduleId, chapterId) => {
          e.preventDefault();
      
          const title = await showModal(
              "Adauga lectia",
              "text",
              "Introdu titlul lectiei"
          );
      
          if (title) {
              const { value: videoFile } = await MySwal.fire({
                  title: "Upload Video",
                  input: "file",
                  inputAttributes: {
                      accept: "video/*",
                  },
                  showCancelButton: true,
                  confirmButtonText: "Upload",
                  cancelButtonText: "Cancel",
                  inputLabel: "Alege un videoclip",
              });
      
              if (videoFile) {
                  // Create a video element to determine the duration
                  const videoElement = document.createElement('video');
                  const objectURL = URL.createObjectURL(videoFile);
      
                  videoElement.src = objectURL;
      
                  // Return a Promise that resolves with the video duration
                  const getVideoDuration = () => {
                      return new Promise((resolve) => {
                          videoElement.onloadedmetadata = () => {
                              resolve(videoElement.duration);
                          };
                      });
                  };
      
                  try {
                      const duration = await getVideoDuration();
                      console.log(`Video duration is: ${duration} seconds`);
      
                      // Do something with the duration, e.g., save it in the lesson data
      
                      setVideoFiles((prev) => ({
                          ...prev,
                          [Date.now()]: {
                              file: videoFile,
                              moduleId,
                              chapterId,
                              title,
                              duration, // Store the duration
                          },
                      }));
      
                      const newLesson = {
                          id: Date.now(),
                          title,
                          video: videoFile.name,
                          duration, // Store the duration in the lesson
                      };
      
                      const updatedModules = modules.map((module) => ({
                          ...module,
                          chapters: module.chapters.map((chapter) =>
                              chapter.id === chapterId
                                  ? {
                                        ...chapter,
                                        lessons: [...chapter.lessons, newLesson],
                                    }
                                  : chapter
                          ),
                      }));
      
                      setModules(updatedModules);
                  } finally {
                      // Release the object URL after the duration is retrieved
                      URL.revokeObjectURL(objectURL);
                  }
      
                  return;
              }
          }
      
          return;
      };

	const deleteModule = (e, moduleId) => {
          e.preventDefault();
           
		Swal.fire({
			title: "Esti sigur ?",
			text: "Aceasta optiune va sterge modulul, toate capitolele si lectiile !",
			icon: "warning",
			showCancelButton: true,
			confirmButtonText: "Da, sterge",
			cancelButtonText: "Nu, anuleaza",
		}).then((result) => {
			if (result.isConfirmed) {
				setModules(
					modules.filter((module) => module.id !== moduleId)
				);

                    // Remove associated video files
                    setVideoFiles(prev => Object.fromEntries(
                         Object.entries(prev).filter(([key, fileData]) => fileData.moduleId !== moduleId)
                    ));
                    return; 
			}
		});
          return; 
	};

	const deleteChapter = (e, moduleId, chapterId) => {
          e.preventDefault(); 

		Swal.fire({
			title: "Esti sigur?",
			text: "Aceasta optiune va sterge capitolul si toate lectiile sale !",
			icon: "warning",
			showCancelButton: true,
			confirmButtonText: "Da, sterge",
			cancelButtonText: "Nu, anuleaza",
		}).then((result) => {
			if (result.isConfirmed) {
				const updatedModules = modules.map((module) => ({
					...module,
					chapters:
						module.id === moduleId
							? module.chapters.filter(
									(chapter) =>
										chapter.id !== chapterId
							  )
							: module.chapters,
				}));
				setModules(updatedModules);

                    setVideoFiles(prev => Object.fromEntries(
                         Object.entries(prev).filter(([key, fileData]) => fileData.chapterId !== chapterId)
                    ));

                    return; 
			}
		});
          return; 
	};

	const deleteLesson = (e, moduleId, chapterId, lessonId) => {
          e.preventDefault(); 

		Swal.fire({
			title: "Esti sigur ?",
			text: "Aceasta optiune va sterge lectia !",
			icon: "warning",
			showCancelButton: true,
			confirmButtonText: "Da, sterge",
			cancelButtonText: "Nu, anuleaza",
		}).then((result) => {
			if (result.isConfirmed) {
				const updatedModules = modules.map((module) => ({
					...module,
					chapters: module.chapters.map((chapter) =>
						chapter.id === chapterId
							? {
									...chapter,
									lessons: chapter.lessons.filter(
										(lesson) =>
											lesson.id !== lessonId
									),
							  }
							: chapter
					),
				}));
				setModules(updatedModules);
                    setVideoFiles(prev => Object.fromEntries(
                         Object.entries(prev).filter(([key, fileData]) => fileData.file !== lessonId)
                    ));
                    return; 
			}
		});
          return; 
	};

	const getNumberedTitle = (text, index, title) =>
		text.length >= 1 ? `${text} ${index + 1} - ${title}` : `${title}`;

     const uploadToS3 = async (file, folder) => {
          const currentDate = new Date();
          const formattedDate = currentDate.toISOString().replace(/[-:]/g, "").slice(0, 14);
          const fileName = `${formattedDate}.${file.type.split('/')[1]}`;
  
          const params = {
              Bucket: 'vinderapidimg',
              Key: `images/impactacademy/courses/${folder}/${fileName}`,
              Body: file,
              ACL: 'public-read',
              ContentType: file.type,
              ContentDisposition: 'inline'
          };
  
          try {
              const data = await s3.upload(params).promise();
              return data.Location;
          } catch (err) {
              console.error(err);
              toast.error(`Error uploading ${folder.slice(0, -1)}.`);
              return null;
          }
     };

     const generateUniqueRandomString = (length) => {
          const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
          let result = '';
        
          while (result.length < length) {
               const char = characters.charAt(Math.floor(Math.random() * characters.length));
        
               if (!result.includes(char)) {
                    result += char;
               }
          }
        
          return result;
     };

	const submitAll = async (data) => {
          data.parentName = selectedCategory
              .replace(/-/g, ' ')                            
              .replace(/\b\w/g, char => char.toUpperCase()); 
          data.parentURL = selectedCategory.toLowerCase().replace(/[^a-z0-9\- ]/gi, '').replace(/[ \-]+/g, '-'); 
      
          data.categoryName = selectedSubcategory
              .replace(/-/g, ' ')                            
              .replace(/\b\w/g, char => char.toUpperCase()); 
          data.categoryURL = selectedSubcategory.toLowerCase().replace(/[^a-z0-9\- ]/gi, '').replace(/[ \-]+/g, '-'); 
      
          data.subcategoryName = selectedChildrens
              .replace(/-/g, ' ')                            
              .replace(/\b\w/g, char => char.toUpperCase()); 
          data.subcategoryURL = selectedChildrens.toLowerCase().replace(/[^a-z0-9\- ]/gi, '').replace(/[ \-]+/g, '-'); 
      
          data.url = data.title.toLowerCase().replace(/[^a-z0-9\- ]/gi, '').replace(/[ \-]+/g, '-') + '-' + generateUniqueRandomString(6); 
          data.level = courseLevel; 
      
          const imageUrl = selectedFile ? await uploadToS3(selectedFile, 'photos') : null;
          const videoUrl = videoFile ? await uploadToS3(videoFile, 'videos') : null;
          
          data.previewImage = imageUrl; 
          data.previewVideo = videoUrl; 
      
          let incrementedLessons = 0; 
      
          const videoUploadPromises = Object.entries(videoFiles).map(async ([key, { file }]) => {
              const url = await uploadToS3(file, 'lessons');
              incrementedLessons += 1; 
              return { key: incrementedLessons, url };
          });
      
          const uploadedVideos = await Promise.all(videoUploadPromises);
      
          
          const updatedModules = modules.map(module => {
               const moduleQuestions = questions[module.id] || []; 
               return {
                    ...module,
                    chapters: module.chapters.map(chapter => ({
                         ...chapter,
                         lessons: chapter.lessons.map((lesson, lessonIndex) => {
                              const uploadedVideo = uploadedVideos.find(video => video.key === lessonIndex + 1);
                              return {
                                   ...lesson,
                                   videoUrl: uploadedVideo ? uploadedVideo.url : lesson.videoUrl
                              };
                         })
                    })),
                    questions: moduleQuestions.length > 0 ? moduleQuestions : null
               };
          });
      
          const steps = [
                         ...updatedModules.flatMap((module, moduleIndex) => [
                         {
                              id: module.id,
                              courseID: 1,
                              title: `Modul ${moduleIndex + 1} - ${module.title}`,
                              type: 'module',
                              parentID: null,
                         },
                         ...module.chapters.flatMap((chapter, chapterIndex) => [
                         {
                              id: chapter.id,
                              courseID: 1,
                              title: `Capitol ${chapterIndex + 1} - ${chapter.title}`,
                              type: 'chapter',
                              parentID: module.id
                         },
                         ...chapter.lessons.map((lesson, lessonIndex) => ({
                              id: lesson.id,
                              courseID: 1,
                              title: `${lesson.title}`,
                              type: 'lesson',
                              parentID: chapter.id,
                              videoUrl: lesson.videoUrl,
                              duration: lesson.duration
                         }))
                    ]),
                    ...module.questions.flatMap((question, questionIndex) => {
                     
                         const questionId = question.id; 
                         return [
                              {
                                   id: questionId,
                                   courseID: 1,
                                   title: question.question, 
                                   type: 'question',          
                                   parentID: module.id,     
                              },
                              ...question.answers.map((answer, answerIndex) => ({
                                   id: answer.id,    
                                   courseID: 1,
                                   title: answer,             
                                   type: 'answer',            
                                   parentID: questionId,      
                                   correctAnswer: answerIndex === question.correctAnswerIndex ? 1 : 0 
                              }))
                      ];
                  })
              ])
          ];
      
          data.steps = steps; 
      
          const response = await fetchWrapper.post('/api/users/create-course', { data });
      
          router.push(response.courseURL); 
      
          return; 
     };

	return (
		<>

               <form onSubmit={handleSubmit(submitAll)}>
               <style jsx>
                    {`
                    .large-modal {
                         width:600px !important;
                         max-width: 600px;
                    }

                    .answer-input {
                         display: flex;
                         flex-direction: column;
                         gap: 10px;
                    }
                    `}
               </style>
			<div className='rbt-course-field-wrapper rbt-default-form'>
				<div className='course-field mb--15'>
					<label htmlFor='field-1'>Titlul cursului</label>
					<input id='field-1' type='text' placeholder='...' {...register('title', { required: true, max: 60, min: 30 })} />
                         {errors.title && <span style={{ fontSize: 15 }} className="error">Trebuie sa introduci titlul cursului de minim 30 de caractere, maxim 60.</span> }
					<small className='d-block mt_dec--5'>
						<i className='feather-info'></i> Trebuie sa introduci titlul cursului de minim 30 de caractere, maxim 60.
					</small>
				</div>

				<div className='course-field mb--15'>
					<label htmlFor='aboutCourse'>
						Descrierea cursului
					</label>
					<textarea id='aboutCourse' rows='10' {...register('description', { required: true, min: 50 })}></textarea>
                         {errors.description && <span style={{ fontSize: 15 }} className="error">Descrierea trebuie sa contina minim 50 de caractere.</span> }
					<small className='d-block mt_dec--5'>
						<i className='feather-info'></i> Acest camp este
						folosit pentru cautarea cursului de catre
						utilizatori, fiti descriptivi.
					</small>
				</div>

				<div className='course-field mb--15 edu-bg-gray'>
					<h6>Pretul cursului</h6>
					<div className='rbt-course-settings-content'>
						<div className='row'>
							<div className='col-lg-8'>
								<div className='tab-content'>
									<div
										className='tab-pane fade advance-tab-content-1 active show'
										id='paid'
										role='tabpanel'
										aria-labelledby='paid-tab'
									>
										<div className='course-field mb--15'>
											<label htmlFor='regularPrice-1'>
												Pretul intreg
											</label>
											<input
												id='regularPrice-1'
												type='number'
												placeholder='Pretul intreg al cursului in RON'
                                                            {...register('price', { required: true, min: 20 })}
											/>
                                                       {errors.price && <span style={{ fontSize: 15 }} className="error">Pretul intreg trebuie sa fie de minim 20 RON.</span> }
										</div>

										<div className='course-field mb--15'>
											<label htmlFor='discountedPrice-1'>
												Pretul redus
											</label>
											<input
												id='discountedPrice-1'
												type='number'
												placeholder='Pretul redus al cursului in RON'
                                                            {...register('priceReduced', { required: false })}
											/>
											<small className='d-block mt_dec--5'>
												<i className='feather-info'></i>{" "}
												Acest camp ramane
												necompletat daca nu
												doriti sa vindeti
												cursul cu un pret
												redus.
											</small>
										</div>
									</div>

									
								</div>
							</div>
						</div>
					</div>
				</div>

				<div className='course-field mb--20'>
					<h6>Alege categoria cursului</h6>
					<div className='rbt-modern-select bg-transparent height-45 w-100 mb--10'>
						<select
							className='w-100'
							onChange={handleCategoryChange}
						>
							{categories.map((category, index) => (
								<option value={category.id} valueName={category.url} key={index}>
									{category.name}
								</option>
							))}
						</select>
					</div>
				</div>

				<div className='course-field mb--20'>
					<h6>Alege subcategoria cursului</h6>
					<div className='rbt-modern-select bg-transparent height-45 w-100 mb--10'>
						<select 
                                   className='w-100'
                                   onChange={handleSubcategoryChange}
                              >
							{subcategories.map((sub, subIndex) => (
								<option value={sub.url} key={subIndex}>
									{sub.name}
								</option>
							))}
						</select>
					</div>
				</div>

                    <div className='course-field mb--20'>
					<h6>Alege urmatoarea subcategorie</h6>
					<div className='rbt-modern-select bg-transparent height-45 w-100 mb--10'>
						<select 
                                   className='w-100'
                                   onChange={handleChildrensChange}
                              >
							{childrens.map((sub, subIndex) => (
								<option value={sub.name} valueName={sub.url} key={subIndex}>
									{sub.name}
								</option>
							))}
						</select>
					</div>
				</div>

                    <div className='course-field mb--20'>
					<h6>Nivelul cursului</h6>
					<div className='rbt-modern-select bg-transparent height-45 w-100 mb--10'>
						<select 
                                   className='w-100'
                                   onChange={handleCourseLevel}
                              >
                                   <option value="Incepator" key={0} selected>
                                        Incepator
                                   </option>
                                   <option value="Avansat" key={1}>
                                        Avansat
                                   </option>
                                   <option value="Expert" key={2}>
                                        Expert
                                   </option>
                                   <option value="Expert" key={3}>
                                        Toate nivelele
                                   </option>
						</select>
					</div>
				</div>

				<div className='course-field mb--20'>
					<h6>Thumbnail-ul cursului</h6>
					<div className='rbt-create-course-thumbnail upload-area'>
						<div className='upload-area'>
							<div
								className='brows-file-wrapper'
								data-black-overlay='9'
							>
								<input
									name='createinputfile'
									id='createinputfile'
									type='file'
									className='inputfile'
                                             accept=".jpg,.jpeg,.png,.webp"
									onChange={handleThumbnailChange}
								/>
								<Image
									id='createfileImage'
									src={preview}
									width={797}
									height={262}
									alt='file image'
								/>

								<label
									className='d-flex'
									htmlFor='createinputfile'
									title='No File Choosen'
								>
									<i className='feather-upload'></i>
									<span className='text-center'>
										Choose a File
									</span>
								</label>
							</div>
						</div>
					</div>

					<small>
						<i className='feather-info'></i> <b>Size:</b>{" "}
						700x430 pixels, <b>File Support:</b> JPG, JPEG,
						PNG, WEBP
					</small>
				</div>

				<div className='course-field mb--20'>
					<h6>Videoclipul preview</h6>
					<div className='rbt-create-course-thumbnail upload-area'>
						<div className='upload-area'>
							<div
								className='brows-file-wrapper'
								data-black-overlay='9'
							>
								<input
									name='createinputfile2'
									id='createinputfile2'
									type='file'
									className='inputfile'
									accept='video/*'
									onChange={handlePreviewChange}
								/>

								{!videoPreview && (
									<Image
										id='createinputfile2'
										src={originalPreview}
										width={797}
										height={262}
										alt='file image'
									/>
								)}

								{videoPreview && (
									<div className='video-preview'>
										<video
											controls
											width='797'
											height='262'
										>
											<source
												src={videoPreview}
												type='video/mp4'
											/>
											Your browser does not
											support the video tag.
										</video>
									</div>
								)}

								<label
									className='d-flex'
									htmlFor='createinputfile2'
									title='No File Choosen'
								>
									<i className='feather-upload'></i>
									<span className='text-center'>
										Choose a File
									</span>
								</label>
							</div>
						</div>
					</div>
					<small>
						<i className='feather-info'></i> <b>Size:</b>{" "}
						700x430 pixels, <b>File Suportate:</b> Orice tip
						de video
					</small>
				</div>

				<div className='course-field mb--20'>
					<h6>Organizarea cursului</h6>

					<button
						className='rbt-btn btn-md btn-gradient hover-icon-reverse'
						type='button'
						onClick={(e) => {
                                   e.preventDefault(); 
                                   addModule(); 
                              }}
					>
						<i className="feather-plus"></i> Adauga modul nou
					</button>
					<hr style={{ marginTop: 30, marginBottom: 30 }} />

					<div>
						<h6>Structura Cursului</h6>
						<ul>
							{modules.map((module, moduleIndex) => (
								<li key={module.id}>
									{getNumberedTitle(
										"Modul ",
										moduleIndex,
										module.title
									)}
                                             <button
                                                  onClick={(e) => addQuestions(e, module.id)}
                                                  className="btn btn-primary"
                                                  style={{ marginLeft: 5 }}
                                             >
                                                  {/* Verificăm dacă există întrebări pentru acest modul */}
                                                  {questions[module.id]?.length > 0 ? "Șterge setul de întrebări" : "Adaugă întrebări"}
                                             </button>
                                             
									<button
										onClick={(e) =>
											addChapter(e, module.id)
										}
                                                  className="btn btn-success"
                                                  style={{marginLeft: 5}}
									>
										Adauga capitol
									</button>
									<button
										onClick={(e) =>
											deleteModule(e, module.id)
										}
                                                  className="btn btn-danger"
                                                  style={{marginLeft: 5}}
									>
										Sterge modul
									</button>
									<ul>
										{module.chapters.map(
											(
												chapter,
												chapterIndex
											) => (
												<li
													key={
														chapter.id
													}
												>
													{getNumberedTitle(
														"Capitol ",
														chapterIndex,
														chapter.title
													)}
													<button
														onClick={(e) =>
															addLesson(
                                                                                e,
																module.id,
																chapter.id
															)
														}
                                                                      className="btn btn-success"
                                                                      style={{marginLeft: 5}}
													>
														Adauga lectie
													</button>
													<button
														onClick={(e) =>
															deleteChapter(
                                                                                e,
																module.id,
																chapter.id
															)
														}
                                                                      className="btn btn-danger"
                                                                      style={{marginLeft: 5}}
													>
														Sterge capitol
													</button>
													<ul>
														{chapter.lessons.map(
															(
																lesson,
																lessonIndex
															) => (
																<li
																	key={
																		lesson.id
																	}
																>
																	{getNumberedTitle(
																		"",
																		lessonIndex,
																		lesson.title
																	)}
																	<button
																		onClick={(e) =>
																			deleteLesson(
                                                                                                    e, 
																				module.id,
																				chapter.id,
																				lesson.id
																			)
																		}
                                                                                          className="btn btn-success"
                                                                                          style={{marginLeft: 5}}
																	>
																		Sterge lectia
																	</button>
																</li>
															)
														)}
													</ul>
												</li>
											)
										)}
									</ul>
								</li>
							))}
						</ul>
					</div>
				</div>
                    <div className='mt--10 row g-5'>
						<div className='col-lg-12'>
							<button
								className='rbt-btn btn-gradient hover-icon-reverse w-100 text-center'
                                        type="submit"
							>
								<span className='icon-reverse-wrapper'>
									<span className='btn-text'>
										Creeaza cursul
									</span>
									<span className='btn-icon'>
										<i className='feather-arrow-right'></i>
									</span>
									<span className='btn-icon'>
										<i className='feather-arrow-right'></i>
									</span>
								</span>
							</button>
						</div>
					</div>
			</div>
               </form>
		</>
	);
};

export default InfoForm;
