import React, { useEffect } from 'react';

// Components 
import InfoForm from "./InfoForm";
import TopicModal from "./TopicModal";

// Database & Other Utils  
import { userService } from '@/services/user.service';
import { fetchWrapper } from '@/helpers/fetch-wrapper'; 
import { useRouter } from 'next/router';

const CreateCourse = () => {
     const user = (!userService.userValue) ? (false):(true); 
     const router = useRouter();

     useEffect(() => {
          if(!user) router.replace('/autentificare'); 
          else {
               const checkAccountType = async () => {
                    const userData = await fetchWrapper.get('/api/users/getdata'); 
                    if(userData[0].userData.accountType == 0) {
                         router.replace('/'); 
                    }
               };

               checkAccountType();
          }
     }, [user, router]);

	return (
		<>
			<div className='row g-5'>
				<div className='col-lg-8'>
					<div className='rbt-accordion-style rbt-accordion-01 rbt-accordion-06 accordion'>
						<div
							className='accordion'
							id='tutionaccordionExamplea1'
						>
							<div className='accordion-item card'>
								<h2
									className='accordion-header card-header'
									id='accOne'
								>
									<button
										className='accordion-button'
										type='button'
										data-bs-toggle='collapse'
										data-bs-target='#accCollapseOne'
										aria-expanded='true'
										aria-controls='accCollapseOne'
									>
										Informatiile cursului
									</button>
								</h2>
								<div
									id='accCollapseOne'
									className='accordion-collapse collapse show'
									aria-labelledby='accOne'
									data-bs-parent='#tutionaccordionExamplea1'
								>
									<div className='accordion-body card-body'>
										<InfoForm />
									</div>
								</div>
							</div>
							
						</div>
					</div>
					
				</div>

				<div className='col-lg-4'>
					<div className='rbt-create-course-sidebar course-sidebar sticky-top rbt-shadow-box rbt-gradient-border'>
						<div className='inner'>
							<div className='section-title mb--30'>
								<h4 className='title'>
									<i className="feather-sun"></i> Sfaturi pentru redactarea cursului
								</h4>
							</div>
							<div className='rbt-course-upload-tips'>
								<ul className='rbt-list-style-1'>
									<li>
										<i className='feather-check'></i>{" "}
										Adauga ambele preturi pentru curs.
									</li>
									<li>
										<i className='feather-check'></i>{" "}
										Ai grija ca imaginile si videoclipurile de preview sa fie cat mai calitative.
									</li>
									<li>
										<i className='feather-check'></i>{" "}
										Fii concret cu descrierea cursului, este printre cele mai importante metode de promovare.
									</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>

			<TopicModal />
		</>
	);
};

export default CreateCourse;
