import Link from 'next/link'; 

import {userService} from '@/services/user.service'; 

const StudentDashboardSidebar = () => {

     const handleLogout = () => {
          userService.logout();
          return;
     };

	return (
		<>
			<div className='rbt-default-sidebar sticky-top rbt-shadow-box rbt-gradient-border'>
				<div className='inner'>
					<div className='content-item-content'>
						<div className='rbt-default-sidebar-wrapper'>
							<div className='section-title mb--20'>
								<h6 className='rbt-title-style-2'>
									Bine ai revenit
								</h6>
							</div>
							<nav className='mainmenu-nav'>
								<ul className='dashboard-mainmenu rbt-default-sidebar-list'>
                                             <li className="nav-item" key={0} role='presentation'>
                                                  <Link href="/profil-student"><i className="feather-home"></i> Dashboard</Link>  
                                             </li>
                                             <li className="nav-item" key={1} role='presentation'>
                                                  <Link href="/profil-student/date"><i className="feather-user"></i> Profilul meu</Link>  
                                             </li>
                                             <li className="nav-item" key={2} role="presentation">
                                                  <Link href="/profil-student/cursuri-inscrise"><i className="feather-book-open"></i><span>Cursurile mele</span></Link>
                                             </li>
                                             <li className="nav-item" key={3} role="presentation">
                                                  <Link href="/profil-student/favorite"><i className="feather-bookmark"></i><span>Lista de dorinte</span></Link>
                                             </li>
                                             <li className="nav-item" key={4} role="presentation">
                                                  <Link href="/profil-student/recenzii"><i className="feather-star"></i><span>Recenzii</span></Link>
                                             </li>
                                             <li className="nav-item" key={5} role="presentation">
                                                  <Link href="/profil-student/istoric-comenzi"><i className="feather-shopping-bag"></i><span>Istoric Comenzi</span></Link>
                                             </li>
									
								</ul>
							</nav>

							<div className='section-title mt--40 mb--20'>
								<h6 className='rbt-title-style-2'>
									Utilizator
								</h6>
							</div>

							<nav className='mainmenu-nav'>
								<ul className='dashboard-mainmenu rbt-default-sidebar-list'>
                                             <li key={0}>
                                                  <Link href="/profil-student/setari"><i className="feather-settings"></i> Setari</Link>
                                             </li>
									<li key={1}>
                                                  <Link href="" onClick={handleLogout}><i className="feather-log-out"></i> Deconectare</Link>
                                             </li>
								</ul>
							</nav>
						</div>
					</div>
				</div>
			</div>
		</>
	);
};

export default StudentDashboardSidebar;
