import React, { useState, useEffect, useRef } from "react";
import Image from "next/image";
import Link from "next/link";

// Utils
import { fetchWrapper } from '@/helpers/fetch-wrapper'; 

// Toast Notification 
import { toast } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';

import AWS from 'aws-sdk';

const StudentDashboardHeader = ({ userData }) => {
     const fileInputRef = useRef(null);
     const fileInputRef2 = useRef(null); 
     
     const [userAvatar, setUserAvatar] = useState(userData.avatar); 
     const [userBackground, setUserBackground] = useState(userData.background); 

     useEffect(() => {
          async function setUserPhotos() {
               setUserAvatar(userData.avatar); 
               setUserBackground(userData.background);
          };
          setUserPhotos();
          
     }, []);

     /*
     
          Edit Profile Photo Algo

     */ 

     const handleButtonClick = (btnID) => {
          if(btnID === 0) {
               if (fileInputRef.current) {
                    fileInputRef.current.click();
               }
          }
          else if(btnID === 1) {
               if (fileInputRef2.current) {
                    fileInputRef2.current.click(); 
               }
          }
     };

     const handleImageChange = async (event) => {
          const uploadedFile = event.target.files[0];

          AWS.config.update({
               accessKeyId: 'AKIA5GGKBZBER6MSVHEX',
               secretAccessKey: '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',
          });
      
          const s3 = new AWS.S3();
          const currentDate = new Date();
          const formattedDate = currentDate.toISOString().replace(/[-:]/g, "").slice(0, 14); 
          const fileName = `${formattedDate}.${uploadedFile.type.split('/')[1]}`;

          const params = {
               Bucket: 'vinderapidimg',
               Key: `images/impactacademy/profile_photos/${fileName}`,
               Body: uploadedFile,
               ACL: 'public-read',
               ContentType: uploadedFile.type,
               ContentDisposition: 'inline'
          };
          
          s3.upload(params, async (err, data) => {
               if (err) {
                   console.error(err);
                   return;
               }
               
               const documentLocation = data.Location;

               try {
                    await fetchWrapper.post('/api/users/settings_avatar', { documentLocation });
                    setUserAvatar(documentLocation); 
                    toast.success('Poza de profil a fost actualizata cu success.');

               } catch (error) {
                   console.error('Error occurred during document upload:', error);
                   toast.error("We've encountered an error during the upload process. Please try again or report a problem.");
               }
          });
     };

     const handleImageChange2 = async (event) => {
          const uploadedFile = event.target.files[0];

          AWS.config.update({
               accessKeyId: 'AKIA5GGKBZBER6MSVHEX',
               secretAccessKey: '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',
          });
      
          const s3 = new AWS.S3();
          const currentDate = new Date();
          const formattedDate = currentDate.toISOString().replace(/[-:]/g, "").slice(0, 14); 
          const fileName = `${formattedDate}.${uploadedFile.type.split('/')[1]}`;

          const params = {
               Bucket: 'vinderapidimg',
               Key: `images/impactacademy/background_photos/${fileName}`,
               Body: uploadedFile,
               ACL: 'public-read',
               ContentType: uploadedFile.type,
               ContentDisposition: 'inline'
          };
          
          s3.upload(params, async (err, data) => {
               if (err) {
                   console.error(err);
                   return;
               }
               
               const documentLocation = data.Location;

               try {
                    await fetchWrapper.post('/api/users/settings_background', { documentLocation });
                    setUserBackground(documentLocation); 
                    toast.success('Poza de coperta a fost actualizata cu success.');

               } catch (error) {
                   console.error('Error occurred during document upload:', error);
                   toast.error("We've encountered an error during the upload process. Please try again or report a problem.");
               }
          });
     };

	return (
          <>
          {userData && (
			<div className='rbt-dashboard-content-wrapper'>

                    <div className="tutor-bg-photo bg_image height-350" style={{ borderBottomLeftRadius:'0px', borderBottomRightRadius:'0px' }}>
                         <Image src={(userBackground) ? (userBackground):(userData.background)} height={350} width={2610} alt="" />
                    </div>
				<div className='rbt-tutor-information'>
					<div className='rbt-tutor-information-left'>
						<div className='thumbnail rbt-avatars size-lg'>
							<Image
								width={300}
								height={300}
								src={(userAvatar) ? (userAvatar):(userData.avatar)}
								alt='Student'
							/>
                                   <div className="rbt-edit-photo-inner">
                                        <button onClick={() => handleButtonClick(0)} className="rbt-edit-photo" title="Upload Photo"><i className="feather-camera"></i></button>
                                        <input
                                             type="file"
                                             accept=".png,.jpg,.jpeg"
                                             ref={fileInputRef}
                                             style={{ display: 'none' }}
                                             onChange={handleImageChange}
                                        />
                                   </div>
						</div>
						<div className='tutor-content'>
							<h5 className='title'>{userData.userName}</h5>
						</div>
					</div>
					<div className='rbt-tutor-information-right'>
                              <div className="tutor-btn">
                                   <button
                                        onClick={() => handleButtonClick(1)}
                                        className='rbt-btn btn-sm btn-border color-white radius-round-10'
                                   >
                                        Schimba coperta
                                   </button>
                                   <input
                                        type="file"
                                        accept=".png,.jpg,.jpeg"
                                        ref={fileInputRef2}
                                        style={{ display: 'none' }}
                                        onChange={handleImageChange2}
                                   />
                              </div>
                              {userData.accountType == 1 && (
                                   <>
                                        <br/>
                                        <div className='tutor-btn'>

                                             <Link
                                                  className='rbt-btn btn-md hover-icon-reverse'
                                                  href='/creeaza-curs'
                                             >
                                                  <span className='icon-reverse-wrapper'>
                                                       <span className='btn-text'>
                                                            Adauga curs nou
                                                       </span>
                                                       <span className='btn-icon'>
                                                            <i className='feather-arrow-right' />
                                                       </span>
                                                       <span className='btn-icon'>
                                                            <i className='feather-arrow-right' />
                                                       </span>
                                                  </span>
                                             </Link>
                                        </div>
                                   </>
                              )}
					</div>
				</div>
			</div>
		
          )}
          </>
	);
};

export default StudentDashboardHeader;
