import Link from "next/link";

const Reviews = () => {
	return (
		<>
			<div className='rbt-dashboard-content bg-color-white rbt-shadow-box'>
				<div className='content'>
					<div className='section-title'>
						<h4 className='rbt-title-style-3'><i className="feather-star"></i> Recenzii</h4>
					</div>

					<div className='rbt-dashboard-table table-responsive mobile-table-750'>
						<table className='rbt-table table table-borderless'>
							<thead>
								<tr>
									<th>Curs</th>
									<th>Recenzie</th>
									<th></th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<th>
										<span className='b3'>
											<Link href='#'>
												Speaking Korean for
												Beginners
											</Link>
										</span>
									</th>
									<td>
										<div className='rbt-review'>
											<div className='rating'>
												<i className='fas fa-star'></i>
												<i className='fas fa-star'></i>
												<i className='fas fa-star'></i>
												<i className='fas fa-star'></i>
												<i className='fas fa-star'></i>
											</div>
											<span className='rating-count'>
												{" "}
												(9 Reviews)
											</span>
										</div>
										<p className='b2'>Good</p>
									</td>
									<td>
										<div className='rbt-button-group justify-content-end'>
											<Link
												className='rbt-btn btn-xs bg-primary-opacity radius-round'
												href='#'
												title='Edit'
											>
												<i className='feather-edit pl--0'></i>
											</Link>
											<Link
												className='rbt-btn btn-xs bg-color-danger-opacity radius-round color-danger'
												href='#'
												title='Delete'
											>
												<i className='feather-trash-2 pl--0'></i>
											</Link>
										</div>
									</td>
								</tr>
								
								
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</>
	);
};

export default Reviews;
