import Swal from "sweetalert2";

const NewsletterThree = () => {
	const validateEmail = (email) => {
		const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
		return re.test(String(email).toLowerCase());
	};

	const handleSubmit = (e) => {
		e.preventDefault();
		const emailInput = document.querySelector(
			".newsletter-form-1 input"
		).value;

		if (validateEmail(emailInput)) {
			Swal.fire({
				title: "Felicitări!",
				text: "Te-ai abonat cu succes la newsletter, de acum vei fi întotdeauna la curent.",
				icon: "success",
				confirmButtonText: "OK",
			});
		} else {
			Swal.fire({
				title: "Eroare!",
				text: "Te rugăm să introduci o adresă de email validă.",
				icon: "error",
				confirmButtonText: "OK",
			});
		}
	};

	return (
		<div className='container'>
			<div className='row g-5 align-items-center'>
				<div className='col-lg-5 col-md-12 col-12' key={0}>
					<div className='inner'>
						<div className='section-title text-center text-lg-start'>
							<h3 className='title'>
								<strong>
									Primește actualizări din partea
									Impact Academy
								</strong>{" "}
								<br />
								<span className='w-400'>
									Abonează-te la Newsletter
								</span>
							</h3>
						</div>
					</div>
				</div>

				<div className='col-lg-7 col-md-12 col-12 text-start text-sm-end'>
					<form
						className='newsletter-form-1 me-0'
						onSubmit={handleSubmit}
					>
						<input
							type='email'
							placeholder='Introduceți adresa de mail'
						/>
						<button
							type='submit'
							className='rbt-btn btn-md btn-gradient hover-icon-reverse'
						>
							<span className='icon-reverse-wrapper'>
								<span className='btn-text'>
									Abonează-te
								</span>
								<span className='btn-icon'>
									<i className='feather-arrow-right'></i>
								</span>
								<span className='btn-icon'>
									<i className='feather-arrow-right'></i>
								</span>
							</span>
						</button>
					</form>
				</div>
			</div>
		</div>
	);
};

export default NewsletterThree;
