import React from "react";
import Link from "next/link";
import { useRouter } from "next/router";

const LessonSidebar = ({ courseData }) => {
	const router = useRouter();
	const isActive = (href) => router.pathname === href;

	// Separate course content
	const courseContent = courseData.courseContent;

	return (
		<>
			<div className='rbt-course-feature-inner rbt-search-activation'>
				<div className='section-title'>
					<h4 className='rbt-title-style-3'>Continutul cursului</h4>
				</div>

				<div className='rbt-accordion-style rbt-accordion-02 for-right-content accordion'>
					<div className='accordion' id='accordionExampleb2'>
			
							{courseData.courseContent.map((data, index) => {
								if (data.type === "module" || data.type === "chapter") {
									return (
										<div className='accordion-item card' key={index}>
											<h2 className='accordion-header card-header' id={`heading${data.id}`}>
												<button
													className={`accordion-button ${!data.isShow ? "collapsed" : ""}`}
													type='button'
													data-bs-toggle='collapse'
													aria-expanded={data.isShow}
													data-bs-target={`#collapse${data.id}`}
													aria-controls={`collapse${data.id}`}
												>
													{data.title}
													<span className='rbt-badge-5 ml--10'>
														{data.type === "module" ? `${data.listItem.length} capitole` : `${data.listItem.length} lectii`}
													</span>
												</button>
											</h2>
											<div
												id={`collapse${data.id}`}
												className={`accordion-collapse collapse ${data.isShow ? "show" : ""}`}
												aria-labelledby={`heading${data.id}`}
											>
												<div className='accordion-body card-body'>
													<ul className='rbt-course-main-content liststyle'>
														{data.listItem &&
															data.listItem.map((innerData, innerIndex) => (
																<li key={innerIndex}>
																	<Link
																		className={isActive(innerData.lessonLink) ? "active" : ""}
																		href={innerData.lessonLink}
																	>
																		<div className='course-content-left'>
																			{innerData.iconHelp ? (
																				<i className='feather-help-circle'></i>
																			) : (
																				<i
																					className={`feather-${innerData.iconFile ? "file-text" : "play-circle"}`}
																				></i>
																			)}
																			<span className='text'>{innerData.lessonName}</span>
																		</div>
																		<div className='course-content-right'>
																			{innerData.label && innerData.time > 0 ? (
																				<span className='min-lable'>{innerData.time} min</span>
																			) : (
																				""
																			)}
																			<span className={`rbt-check ${isActive(innerData.lessonLink) ? "" : "unread"}`}>
																				<i className={`feather-${isActive(innerData.lessonLink) ? "check" : "circle"}`}></i>
																			</span>
																		</div>
																	</Link>
																</li>
															))}
													</ul>
												</div>
											</div>
										</div>
									);
								}

								// Render lessons and questions directly in the list
								if (data.type === "lesson" || data.type === "question") {
									return (
										<li key={data.id}>
											<Link
												className={isActive(data.lessonLink) ? "active" : ""}
												href={data.lessonLink}
											>
												<div className='course-content-left'>
													<i className={`feather-${data.type === "lesson" ? "play-circle" : "help-circle"}`}></i>
													<span className='text'>{data.title}</span>
												</div>
												<div className='course-content-right'>
													{data.duration > 0 ? (
														<span className='min-lable'>{data.duration} min</span>
													) : (
														""
													)}
													<span className={`rbt-check ${isActive(data.lessonLink) ? "" : "unread"}`}>
														<i className={`feather-${isActive(data.lessonLink) ? "check" : "circle"}`}></i>
													</span>
												</div>
											</Link>
										</li>
									);
								}

								return null; // Return null if none of the conditions match
                                   })}
					</div>
				</div>
			</div>
		</>
	);
};

export default LessonSidebar;
