import Link from "next/link";
import { useAppContext } from "@/context/Context";
import { useRouter } from "next/router";
import React, { useState } from 'react';
 
const Search = () => {
     const { search } = useAppContext();
     const [searchTerm, setSearchTerm] = useState(''); 

     const router = useRouter();

     const formatSearchTerm = (term) => {
          return term.toLowerCase().replace(/\s+/g, '-').replace(/[^a-z0-9-]/g, '');
     };
     
     const handleSearch = (e) => {
          e.preventDefault();
          const formattedSearch = "/q-" + formatSearchTerm(searchTerm); 
          if (searchTerm) {
               router.push(formattedSearch); 
          }
     };

     return (
          <>
               <div className={`rbt-search-dropdown ${!search ? "active" : ""}`}>
                    <div className="wrapper">
                         <div className="row">
                              <div className="col-lg-12">
                                   <form action="#">
                                        <input 
                                             type="text" 
                                             placeholder="Ce cauți?" 
                                             value={searchTerm} 
                                             onChange={(e) => setSearchTerm(e.target.value)}
                                        />
                                        <div className="submit-btn">
                                             <button className="rbt-btn btn-gradient btn-md" onClick={handleSearch}>
                                                  Caută
                                             </button>
                                        </div>
                                   </form>
                              </div>
                         </div>
                         
                    </div>
               </div>
          </>
     );
};

export default Search;
