import Link from "next/link";
import { useState } from "react";

const Nav = ({ categories = [] }) => {
     const [activeCategory, setActiveCategory] = useState(null);
     const [activeSubCategory, setActiveSubCategory] = useState({}); 

     const handleSubCategoryHover = (categoryIndex, subIndex) => {
          setActiveSubCategory({
               [categoryIndex]: subIndex 
          });
     };

     const handleCategoryLeave = () => {
          setActiveCategory(null);
          setActiveSubCategory({}); 
     };

     return (
          <>
               <style jsx>
                    {`
                    .mainmenu .submenu {
                         position: absolute;
                         top: 100%;
                         left: 0;
                         background-color: #fff;
                         display: none;
                         z-index: 10;
                    }

                    .mainmenu .has-dropdown.open .submenu {
                         display: block;
                    }

                    .dropdown-child-wrapper {
                         position: absolute;
                         top: 0;
                         left: 100%; 
                         background-color: #fff;
                         z-index: 10;
                         display: none;
                    }

                    .dropdown-parent-list.open .dropdown-child-wrapper {
                         display: block;
                    }

                    .dropdown-child-list {
                         padding: 10px;
                         white-space: nowrap;
                    }

                    .dropdown-parent-list {
                         position: relative;
                    }

                    .mainmenu .has-dropdown {
                         position: relative;
                    }
                    `}
               </style>

               <nav className="mainmenu-nav update-category-dropdown">
                    <ul className="mainmenu dropdown-parent-wrapper">
                         {categories.map((category, categoryIndex) => (
                              <li
                                   className={`has-dropdown ${activeCategory === categoryIndex ? 'open' : ''}`}
                                   key={category.id}
                                   onMouseEnter={() => setActiveCategory(categoryIndex)}
                                   onMouseLeave={handleCategoryLeave}
                              >
                                   <Link href={`/${category.url}`}>
                                        {category.name}
                                        {category.children && category.children.length > 0 && (
                                             <i className="feather-chevron-right"></i>
                                        )}
                                   </Link>

                                   {category.children && category.children.length > 0 && (
                                        <ul className="submenu">
                                             {category.children.map((sub, subIndex) => (
                                                  <li
                                                       className={`dropdown-parent-list ${activeSubCategory[categoryIndex] === subIndex ? 'open' : ''}`}
                                                       key={sub.id}
                                                       onMouseEnter={() => handleSubCategoryHover(categoryIndex, subIndex)}
                                                       onMouseLeave={() => handleSubCategoryHover(categoryIndex, null)}
                                                  >
                                                       <Link href={`/${category.url}/${sub.url}`}>
                                                            {sub.name}
                                                            {sub.subChildren && sub.subChildren.length > 0 && (
                                                                 <i className="feather-chevron-right"></i>
                                                            )}
                                                       </Link>

                                                       {sub.subChildren && sub.subChildren.length > 0 && (
                                                            <div className="dropdown-child-wrapper">
                                                                 <div className="child-inner">
                                                                      {sub.subChildren.map((subSub) => (
                                                                           <div
                                                                           className="dropdown-child-list"
                                                                           key={subSub.id}
                                                                           >
                                                                           <Link href={`/${category.url}/${sub.url}/${subSub.url}`}>
                                                                                {subSub.name}
                                                                           </Link>
                                                                           </div>
                                                                      ))}
                                                                 </div>
                                                            </div>
                                                       )}
                                                  </li>
                                             ))}
                                        </ul>
                                   )}
                              </li>
                         ))}
                    </ul>
               </nav>
          </>
     );
};

export default Nav;
