import { useState, useEffect } from 'react';
import Image from "next/image";
import Link from "next/link";

import logo from "../../public/images/logo/logo.svg";

import Nav from "./Nav";
import { useAppContext } from "@/context/Context";

import { fetchWrapper } from '@/helpers/fetch-wrapper';

const MobileMenu = () => {
	const { mobile, setMobile } = useAppContext();
     const [categories, setCategories] = useState([]); 

     useEffect(() => {
          const fetchCategories = async () => {
               try {
                    const categResponse = await fetchWrapper.get('/api/categories'); 

                    setCategories(categResponse.categories); 
               }
               catch(err) {
                    console.error('Failed to fetch categories', err);
               }
          };
          fetchCategories(); 
     }, []);
     
	return (
		<>
			<div className={`popup-mobile-menu ${mobile ? "" : "active"}`}>
				<div className='inner-wrapper'>
					<div className='inner-top'>
						<div className='content'>
							<div className=''>
								<Link href='/'>
									<Image
										src={logo}
										width={137}
										height={45}
										alt='Education Logo Images'
									/>
								</Link>
							</div>
							<div className='rbt-btn-close'>
								<button
									className='close-button rbt-round-btn'
									onClick={() => setMobile(!mobile)}
								>
									<i className='feather-x'></i>
								</button>
							</div>
						</div>
						
					</div>

                         <nav className="mainmenu-nav">
                              <ul className="mainmenu">
                                   <li
                                        className={`with-megamenu has-menu-child-item position-static`}
                                   >
                                        {categories.map((category, categoryIndex) => (
                                             <Link href={category.url} key={categoryIndex}>
                                                  {category.name} 
                                             </Link>
                                        ))}
                                   </li>
                              </ul>
                         </nav>

					<Nav />

					
				</div>
			</div>
		</>
	);
};

export default MobileMenu;
