import React, { useEffect, useState } from "react";
import { fetchWrapper } from '@/helpers/fetch-wrapper';

import Link from "next/link";
import Image from "next/image";

import HeaderRight from "../Header-Right/HeaderRight";
import Search from "../Offcanvas/Search";
import Nav from "../Nav";

import logo from "../../../public/images/logo/logo.svg";

const Header = ({
     headerType,
     gapSpaceBetween,
     sticky,
     headerSticky,
     navigationEnd,
     container,
}) => {
     const [isSticky, setIsSticky] = useState(false);
     const [categories, setCategories] = useState([]); 

     useEffect(() => {
          const handleScroll = () => {
               const scrolled = window.scrollY;
               if (scrolled > 0) {
                    setIsSticky(true);
               } else {
                    setIsSticky(false);
               }
          };

          window.addEventListener("scroll", handleScroll);

          const fetchCategories = async () => {
               try {
                    const categResponse = await fetchWrapper.get('/api/categories'); 

                    setCategories(categResponse.categories); 
               }
               catch(err) {
                    console.error('Failed to fetch categories', err);
               }
          };
          fetchCategories(); 

          return () => {
               window.removeEventListener("scroll", handleScroll);
          };
     }, []);
     return (
          <>
               <div
                    className={`rbt-header-wrapper ${gapSpaceBetween} ${sticky}  ${!headerType && isSticky ? `${headerSticky}` : ""
                         }`}
               >
                    <div className={`${container}`}>
                         <div className={`mainbar-row ${navigationEnd} align-items-center`}>
                              <div className="header-left rbt-header-content">
                                   <div className="header-info">
                                        <div style={{ marginBottom: 10, marginTop: 10 }}>
                                             <Link href="/">
                                                  <Image
                                                       src={logo}
                                                       width={115}
                                                       height={80}
                                                       priority={true}
                                                       alt="Impact Academy"
                                                  />
                                             </Link>
                                        </div>
                                   </div>

         
                              </div>

                              <div className="rbt-main-navigation d-none d-xl-block">
                                   <Nav categories={categories}/>
                              </div>

                              <HeaderRight
                                   userType="Admin"
                                   btnText="Înscrie-te acum"
                                   btnClass="rbt-marquee-btn marquee-auto btn-border-gradient radius-round btn-sm hover-transform-none"
                              />
                         </div>
                    </div>
                    <Search />
               </div>
          </>
     );
};

export default Header;
