// Natives 
import React, { useEffect, useState } from 'react'; 
import Link from 'next/link';

// Utils
import { userService } from '@/services/user.service'; 
import { fetchWrapper } from '@/helpers/fetch-wrapper'; 

import { useSelector } from "react-redux";

import User from "@/components/Header/Offcanvas/User";
import { useAppContext } from "@/context/Context";
import Image from 'next/image';


const HeaderRight = ({ btnClass, btnText, userType }) => {
	const { mobile, setMobile, search, setSearch, cartToggle, setCart } =
		useAppContext();

     const [userData, setUserData] = useState([]); 
     const [userText, setUserText] = useState('Autentificare'); 
     const [userState, setUserState] = useState(0); 

     useEffect(() => {
          
          async function fetchUserData() {
               const response = await fetchWrapper.get(`/api/users/getdata`);

               setUserData(response[0].userData);
               setUserText(response[0].userData.userName);
               setUserState(1); 
          };
          fetchUserData();
     
     }, []);

     const handleLogout = () => {
          userService.logout(); 
     };

	return (
		<div className='header-right'>
			<ul className='quick-access'>
				<li className='access-icon'>
					<Link
						className={`search-trigger-active rbt-round-btn ${
							search ? "" : "open"
						}`}
						href='#'
						onClick={() => setSearch(!search)}
                              aria-label={search ? "Inchide cautarea" : "Deschide cautarea"}
					>
						<i className='feather-search'></i>
					</Link>
				</li>

				<li className='access-icon rbt-mini-cart'>
					<Link
						className='rbt-cart-sidenav-activation rbt-round-btn'
						href='/cos-de-cumparaturi'
                              aria-label="Cos de cumparaturi"
					>
						<i className='feather-shopping-cart'></i>
						
					</Link>
				</li>

				<li className='account-access rbt-user-wrapper d-none d-xl-block'>
                         <Link href={userData.userName ? ('/'):('/autentificare')}>
                              <i className={userData.userName ? ('feather-user'):('feather-log-in')}></i>
                              {userText.split(" ")[0]}
                         </Link>

					{userState == 1 && ( 
                              <>
                              <div className='rbt-user-menu-list-wrapper'>
                                   <div className='inner' key={0}>
                                        <div className='rbt-admin-profile'>
                                             
                                             <div className='admin-thumbnail'>
                                                  <Image
                                                       src={userData.avatar}
                                                       width={43}
                                                       height={43}
                                                       alt='User Avatar'
                                                  />
                                             </div>

                                             <div className='admin-info'>
                                                  <span className='name'>
                                                       {userData.userName}
                                                  </span>
                                                  <Link
                                                       className='rbt-btn-link color-primary'
                                                       href={userData.accountType ? ('/profil-instructor'):('/profil-student')}
                                                  >
                                                       Vezi profilul
                                                  </Link>
                                             </div>

                                        </div>
                                        
                                        <hr className='mt--10 mb--10' />
                                             <ul className='user-list-wrapper'>
                                                  <li>
                                                       <Link href={userData.accountType ? ('/profil-instructor/setari'):('/profil-student/setari')}>
                                                            <i className='feather-settings'></i>
                                                            <span>Setari</span>
                                                       </Link>
                                                  </li>
                                                  <li>
                                                       <Link href='#' onClick={handleLogout}>
                                                            <i className='feather-log-out'></i>
                                                            <span>Logout</span>
                                                       </Link>
                                                  </li>
                                             </ul>
                                   </div>
                              </div>
                              </>
                         )}
				</li>

				<li className='access-icon rbt-user-wrapper d-block d-xl-none'>
                         <Link href={userData.userName ? ('/'):('/autentificare')}>
                              <i className={userData.userName ? ('feather-user'):('feather-log-in')}></i>
                              {userText.split(" ")[0]}
                         </Link>

					{userState == 1 && ( 
                              <>
                              <div className='rbt-user-menu-list-wrapper'>
                                   <div className='inner' key={0}>
                                        <div className='rbt-admin-profile'>
                                             
                                             <div className='admin-thumbnail'>
                                                  <Image
                                                       src={userData.avatar}
                                                       width={43}
                                                       height={43}
                                                       alt='User Avatar'
                                                  />
                                             </div>

                                             <div className='admin-info'>
                                                  <span className='name'>
                                                       {userData.userName}
                                                  </span>
                                                  <Link
                                                       className='rbt-btn-link color-primary'
                                                       href={userData.accountType ? ('/profil-instructor'):('/profil-student')}
                                                  >
                                                       Vezi profilul
                                                  </Link>
                                             </div>

                                        </div>
                                        
                                        <hr className='mt--10 mb--10' />
                                             <ul className='user-list-wrapper'>
                                                  <li>
                                                       <Link href={userData.accountType ? ('/profil-instructor/setari'):('/profil-student/setari')}>
                                                            <i className='feather-settings'></i>
                                                            <span>Setari</span>
                                                       </Link>
                                                  </li>
                                                  <li>
                                                       <Link href='#' onClick={handleLogout}>
                                                            <i className='feather-log-out'></i>
                                                            <span>Logout</span>
                                                       </Link>
                                                  </li>
                                             </ul>
                                   </div>
                              </div>
                              </>
                         )}
				</li>
			</ul>

			<div className='mobile-menu-bar d-block d-xl-none'>
				<div className='hamberger'>
					<button
						className='hamberger-button rbt-round-btn'
						onClick={() => setMobile(!mobile)}
					>
						<i className='feather-menu'></i>
					</button>
				</div>
			</div>
		</div>
	);
};

export default HeaderRight;
