import Link from "next/link";
import CategoryData from "../../../data/elements/category";

import { useEffect, useState } from 'react'; 
import { fetchWrapper } from "@/helpers/fetch-wrapper";

const Category = () => {
     const [categories, setCategories] = useState([]); 

     useEffect(() => {
          const fetchCategories = async () => {
               try {
                    const categResponse = await fetchWrapper.get('/api/categories'); 

                    setCategories(categResponse.categories); 
               }
               catch(err) {
                    console.error('Failed to fetch categories', err);
               }
          };
          fetchCategories(); 
     }, []);

     console.log(categories);

	return (
		<div className='rbt-category-menu-wrapper rbt-category-update'>
			<div className='rbt-category-btn'>
				<div className='rbt-offcanvas-trigger md-size icon'>
					<span className='d-none d-xl-block'>
						<i className='feather-grid'></i>
					</span>
					<i
						title='Category'
						className='feather-grid d-block d-xl-none'
					></i>
				</div>
				<span className='category-text d-none d-xl-block'>
					Categorii
				</span>
			</div>

			<div className='update-category-dropdown'>
				<div className='inner'>
					<ul className='dropdown-parent-wrapper'>
                              {categories.map((category, index) => (
                                   <li className={`dropdown-parent-list`} key={index}>
                                        <Link href={`/${category.url}`}>{category.name}</Link>
                                        {category.subcategories && category.subcategories.length > 0 && (
                                             <div className='dropdown-child-wrapper'>
                                                  <div className='child-inner'>
                                                       {category.subcategories.map((sub, subIndex) => (
                                                            <div
                                                                 className='dropdown-child-list'
                                                                 key={subIndex}
                                                            >
                                                                 <Link href={`/${sub.url}`}>
                                                                      {sub.name}
                                                                 </Link>
                                                            </div>
                                                       ))}
                                                  </div>
                                             </div>
                                        )}
                                   </li>
                              ))}
					</ul>
				</div>
			</div>
		</div>
	);
};
export default Category;
