import Image from "next/image";
import Link from "next/link";

import logo from "../../public/images/logo/logo.svg";

import CopyRight from "./CopyRight";

const FooterOne = ({ bgColor }) => {
     return (
          <>
               <footer
                    className={`rbt-footer footer-style-1 ${bgColor ? bgColor : "bg-color-white"
                         } overflow-hidden`}
               >
                    <div className="footer-top">
                         <div className="container">
                              
                              <div className="row g-5" key={0}>
                                   <div className="col-lg-4 col-md-6 col-sm-6 col-12">
                                        <div className="footer-widget">
                                             <div style={{ marginTop: 10, marginBottom: 10 }}>
                                                  <Link href="/">
                                                       <Image
                                                            src={logo}
                                                            width={130}
                                                            height={50}
                                                            alt="Impact Academy"
                                                       />
                                                  </Link>
                                             </div>

                                             <ul className="social-icon social-default justify-content-start">
                                                  <li key={0}>
                                                       <Link href="https://www.facebook.com/" aria-label="ImpactAcademy Facebook Social Media Link">
                                                            <i className="feather-facebook"></i>
                                                       </Link>
                                                  </li>
                                                  <li key={1}>
                                                       <Link href="https://www.instagram.com/" aria-label="ImpactAcademy Instagram Social Media Link">
                                                            <i className="feather-instagram"></i>
                                                       </Link>
                                                  </li>
                                             </ul>

                                             <div className="contact-btn mt--30">
                                                  <Link
                                                       className="rbt-btn hover-icon-reverse btn-border-gradient radius-round"
                                                       href="/contact"
                                                  >
                                                       <div className="icon-reverse-wrapper">
                                                            <span className="btn-text">Contactați-ne</span>
                                                            <span className="btn-icon">
                                                                 <i className="feather-arrow-right"></i>
                                                            </span>
                                                            <span className="btn-icon">
                                                                 <i className="feather-arrow-right"></i>
                                                            </span>
                                                       </div>
                                                  </Link>
                                             </div>
                                        </div>
                                   </div>

                                   <div className="col-lg-4 col-md-6 col-sm-6 col-12">
                                        <center>
                                             <Link href="https://stripe.com/" aria-label="ImpactAcademy Secure Payment Processor Stripe"> <Image alt="ImpactAcademy Secure Payment Processor Stripe" style={{ marginTop: -20, marginBottom: -55 }} src="/stripe.svg" width="310" height="100"/></Link>
                                             <Link href="https://anpc.ro/" aria-label="ANPC"> <Image alt="ImpactAcademy ANPC" style={{ marginTop: 20, marginBottom: 20 }} src="https://simpixel.ro/wp-content/uploads/2022/09/SOL.svg" width="235" height="100"/></Link>
                                             <Link href="https://anpc.ro/ce-este-sal" aria-label="ANPC SAL"> <Image alt="ImpactAcademy SAL" style={{ marginTop: 20, marginBottom: 20 }}src="https://simpixel.ro/wp-content/uploads/2022/09/SAL.svg" width="235" height="100"/></Link>
                                        </center>
                                   </div>

                                   <div className="col-lg-4 col-md-6 col-sm-6 col-12">
                                        <div className="footer-widget">
                                             <h3 className="ft-title">Contactați-ne</h3>
                                             <ul className="ft-link">
                                                  <li>
                                                       <span>Telefon: </span>
                                                       <Link href="#">+40...</Link>
                                                  </li>
                                                  <li>
                                                       <span>E-mail:</span>{" "}
                                                       <Link href="mailto:support@impactacademy.ro">
                                                            support@impactacademy.ro
                                                       </Link>
                                                  </li>
                                             </ul>

                                             <form className="newsletter-form mt--20" action="#">
                                                  <h3 className="w-600">Newsletter</h3>
                                                  <p className="description">Peste 1000 de studenți sunt abonați. Nu ezitați să vă alăturați!</p>

                                                  <div className="form-group right-icon icon-email mb--20">
                                                       {/* <label htmlFor="email">Enter Your Email Here</label> */}
                                                       <input
                                                            id="email"
                                                            type="email"
                                                            placeholder="Introduceți adresa de mail"
                                                       />
                                                  </div>

                                                  <div className="form-group mb--0">
                                                       <button
                                                            className="rbt-btn rbt-switch-btn btn-gradient radius-round btn-sm"
                                                            type="submit"
                                                       >
                                                            <span data-text="Abonează-te">Abonează-te</span>
                                                       </button>
                                                  </div>
                                             </form>
                                        </div>
                                   </div>
                              </div>
                            
                         </div>
                    </div>

                    <CopyRight />
               </footer>
          </>
     );
};

export default FooterOne;
