import { useState, useEffect } from 'react';
import { useRouter } from 'next/router'; 

// Helpers 
import { fetchWrapper } from '@/helpers/fetch-wrapper';

// Toast Notifications
import { toast } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';

function FavoriteButton({ item, userSavedAds }) {
     const router = useRouter();

     const [isFavorite, setIsFavorite] = useState(false);

     useEffect(() => {
          setIsFavorite(userSavedAds.includes(item.id));
     }, [item.id, userSavedAds]);

     const handleFavoriteButton = async () => {
          const response = isFavorite
          ? await fetchWrapper.delete(`/api/users/favorites?itemID=${item.id}`)
          : await fetchWrapper.put(`/api/users/favorites?itemID=${item.id}`);

          setIsFavorite(!isFavorite); 

          toast.success(response);

          if(response) {
               if(router.pathname == '/profil-student/favorite') {
                    router.reload();
               }
          }
     };

     return (
          <button
               type="button"
               title={isFavorite ? 'Elimina de la favorite' : 'Adauga la favorite'}
               onClick={handleFavoriteButton}
               style={{ background: 'transparent', color:'black', borderRadius: 50, border: 'none' }}
          >
               <i aria-hidden className={isFavorite ? 'fa fa-bookmark' : 'feather-bookmark'}></i>
          </button>
     );
}

export default FavoriteButton;