import React, { useState, useEffect } from "react";
import Image from "next/image";
import Link from "next/link";

import "venobox/dist/venobox.min.css";

import { useDispatch, useSelector } from "react-redux";
import { useAppContext } from "@/context/Context";

import { fetchWrapper } from "@/helpers/fetch-wrapper";
import {useRouter} from 'next/router'; 

// Toast Notifications 
import { toast } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';

const Viedo = ({ courseData }) => {
     const [toggle, setToggle] = useState(false);
     const [hideOnScroll, setHideOnScroll] = useState(false);

     const router = useRouter(); 

     const addToCart = async (productID, productRestaurant, productName, productPrice, productPriceReduced) => {
          const bodyData = { 
               userQantity: 1, 
               productID: productID, 
               restaurantID: productRestaurant, 
               productName: productName,
               productPrice: productPrice, 
               productPriceReduced: productPriceReduced
          };

          const response = await fetchWrapper.post('/api/users/cart', bodyData); 

          if(response.status === 200) { 
               if(response.message) {
                    router.push('/cos-de-cumparaturi'); 
               }
               else if(response.error){
                    toast.error(response.error); 
               }
          } 
     }

     // =====> For video PopUp
     useEffect(() => {
          import("venobox/dist/venobox.min.js").then((venobox) => {
               new venobox.default({
                    selector: ".popup-video",
               });
          });

          const handleScroll = () => {
               const currentScrollPos = window.pageYOffset;
               const isHide = currentScrollPos > 200;

               setHideOnScroll(isHide);
          };

          window.addEventListener("scroll", handleScroll);

          return () => {
               window.removeEventListener("scroll", handleScroll);
          };
     }, []);

     return (
          <>
               <Link
                    className={`video-popup-with-text video-popup-wrapper text-center popup-video sidebar-video-hidden mb--15 ${hideOnScroll ? "d-none" : ""
                         }`}
                    data-vbtype="video"
                    href={courseData.previewVideo}
               >
                    <div className="video-content">
                        
                         <Image
                              className="w-100 rbt-radius"
                              src={courseData.previewImage}
                              width={355}
                              height={255}
                              alt="Video Images"
                         />
                   
                         <div className="position-to-top">
                              <span className="rbt-btn rounded-player-2 with-animation">
                                   <span className="play-icon"></span>
                              </span>
                         </div>
                         <span className="play-view-text d-block color-white">
                              <i className="feather-eye"></i> Previzualizează cursul
                         </span>
                    </div>
               </Link>
               <div className="content-item-content">
                    <div className="rbt-price-wrapper d-flex flex-wrap align-items-center justify-content-between">
                         <div className="rbt-price">
                              <span className="current-price">{courseData.priceReduced} RON</span>
                              <span className="off-price">{courseData.price} RON</span>
                         </div>
                    </div>

                    <div className="add-to-card-button mt--15">
                         <Link
                              className="rbt-btn btn-gradient icon-hover w-100 d-block text-center"
                              href="#"
                              onClick={() =>
                                   addToCart(courseData.id, courseData.instructorID, courseData.title, courseData.price, courseData.priceReduced)
                              }
                         >
                              <span className="btn-text">Adaugă în coș</span>
                              <span className="btn-icon">
                                   <i className="feather-arrow-right"></i>
                              </span>
                         </Link>
                    </div>
                   
    
               </div>
          </>
     );
};

export default Viedo;
