import React, { useState } from "react";

import Image from "next/image";
import Link from "next/link";

const Featured = ({ reviews }) => {
     
     return (
     <>
          {reviews.length > 0 && 
               <div
                    className={`about-author-list rbt-shadow-box featured-wrapper mt--30`}
               >
                    <div className="has-show-more-inner-content rbt-featured-review-list-wrapper">

                         {reviews.map((review, index) => (
                              <div className="rbt-course-review about-author" key={0}>
                                   <div className="media">
                                        <div className="media-body">
                                             <div className="author-info">
                                                  <h5 className="title">
                                                       <span className="hover-flip-item-wrapper" href="#">
                                                            {review.reviewBy}
                                                       </span>
                                                  </h5>
                                                  <div className="rating">
                                                       {Array.from({ length: review.reviewStars }, (_, index) => (
                                                            <i key={index} className="fas fa-star" style={{ color: '#FF9747' }}></i>
                                                       ))}
                                                  </div>
                                             </div>
                                             <div className="content">
                                                  <p className="description">{review.reviewText}</p>
                                             </div>
                                        </div>
                                   </div>
                              </div>
                         ))}
                    
                    </div>
               </div>
          }
          {reviews.length == 0 &&
               <span>Nu exista recenzii.</span>
          }
     </>
     );
};

export default Featured;
