import Image from "next/image";
import Link from "next/link";

const CourseBreadcrumb = ({ courseData }) => {
     return (
          <>
               <div className="col-lg-8">
                    <div className="content text-start">
                         <ul className="page-list">
                              <li className="rbt-breadcrumb-item">
                                   <Link href="/">Acasă</Link>
                              </li>
                              <li>
                                   <div className="icon-right">
                                        <i className="feather-chevron-right"></i>
                                   </div>
                              </li>
                              <li className="rbt-breadcrumb-item active">
                                   {courseData.categoryName}
                              </li>
                         </ul>
                         <h2 className="title">{courseData.title}</h2>
                         <p className="description">{courseData.description}</p>

                         <div className="d-flex align-items-center mb--20 flex-wrap rbt-course-details-feature">
                              

                              <div className="feature-sin rating">
                                   <Link href="#">{getMatchCourse.star}</Link>
                                   <Link href="#">
                                        <i className="fa fa-star"></i>
                                   </Link>
                                   <Link href="#">
                                        <i className="fa fa-star"></i>
                                   </Link>
                                   <Link href="#">
                                        <i className="fa fa-star"></i>
                                   </Link>
                                   <Link href="#">
                                        <i className="fa fa-star"></i>
                                   </Link>
                                   <Link href="#">
                                        <i className="fa fa-star"></i>
                                   </Link>
                              </div>

                              <div className="feature-sin total-rating">
                                   <Link className="rbt-badge-4" href="#">
                                        {getMatchCourse.ratingNumber} Recenzii
                                   </Link>
                              </div>

                              <div className="feature-sin total-student">
                                   <span> {getMatchCourse.studentNumber} Studenți</span>
                              </div>
                         </div>

                         <div className="rbt-author-meta mb--20">
                              <div className="rbt-avater">
                                   <Link href={`/profile/${getMatchCourse.id}`}>
                                        {getMatchCourse.userImg && (
                                             <Image
                                                  width={40}
                                                  height={40}
                                                  src={getMatchCourse.userImg}
                                                  alt={getMatchCourse.userName}
                                             />
                                        )}
                                   </Link>
                              </div>
                              <div className="rbt-author-info">
                                   De{" "}
                                   <Link href={`/profile/${getMatchCourse.id}`}>
                                        {getMatchCourse.userName}
                                   </Link>{" "}
                                   în{" "}
                                   <Link href="#">
                                        {getMatchCourse.userCategory}
                                   </Link>
                              </div>
                         </div>

                         <ul className="rbt-meta">
                              <li>
                                   <i className="feather-calendar"></i>Actualizat{" "}
                                   {getMatchCourse.date}
                              </li>
                              <li>
                                   <i className="feather-globe"></i>
                                   {getMatchCourse.language}
                              </li>
                              <li>
                                   <i className="feather-award"></i> {getMatchCourse.courseAward}
                              </li>
                         </ul>
                    </div>
               </div>
          </>
     );
};

export default CourseBreadcrumb;
