import Link from "next/link";
import { useRouter } from "next/router";

import React, { useState, useEffect } from "react";

const CourseActionBottom = ({ courseData }) => {
     const router = useRouter();
     const path = router.pathname;
     const [hideOnScroll, setHideOnScroll] = useState(false);

     useEffect(() => {
          const handleScroll = () => {
               const ScrollPosition = window.pageYOffset;
               let isHide;
               if (path === courseData.url) {
                    isHide = ScrollPosition > 4365 && ScrollPosition < 5609;
               } else {
                    isHide = ScrollPosition > 4365;
               }

               setHideOnScroll(isHide);
          };

          window.addEventListener("scroll", handleScroll);

          return () => {
               window.removeEventListener("scroll", handleScroll);
          };
     }, [path]);
     return (
          <>
               <div
                    className={`rbt-course-action-bottom ${hideOnScroll ? "rbt-course-action-active" : ""
                         }`}
               >
                    <div className="container">
                         <div className="row align-items-center">
                              <div className="col-lg-6 col-md-6">
                                   <div className="section-title text-center text-md-start">
                                        <h5 className="title mb--0">{courseData.title}</h5>
                                   </div>
                              </div>
                              <div className="col-lg-6 col-md-6 mt_sm--15">
                                   <div className="course-action-bottom-right rbt-single-group">
                                        <div className="rbt-single-list rbt-price large-size justify-content-center">
                                             <span className="current-price color-primary">
                                                  ${courseData.price}
                                             </span>
                                             <span className="off-price">
                                                  ${courseData.priceReduced}
                                             </span>
                                        </div>
                                        <div className="rbt-single-list action-btn">
                                             <Link
                                                  className="rbt-btn btn-gradient hover-icon-reverse btn-md"
                                                  href="#"
                                             >
                                                  <span className="icon-reverse-wrapper">
                                                       <span className="btn-text">Cumpără acum</span>
                                                       <span className="btn-icon">
                                                            <i className="feather-arrow-right"></i>
                                                       </span>
                                                       <span className="btn-icon">
                                                            <i className="feather-arrow-right"></i>
                                                       </span>
                                                  </span>
                                             </Link>
                                        </div>
                                   </div>
                              </div>
                         </div>
                    </div>
               </div>
          </>
     );
};

export default CourseActionBottom;
