import Link from "next/link";
import Image from "next/image";

import CourseDetails from "../../data/course-details/courseData.json";
import useCategoryCount from "@/context/useCategoryCount";

const CategorySix = ({lastCategories}) => {
     return (
          <>
               {lastCategories &&
                    lastCategories.map((item, innerIndex) => {
                         return (
                              <div className="col-lg-3 col-md-6 col-sm-6 col-12" key={innerIndex}>
                                   <Link
                                        className="rbt-cat-box rbt-cat-box-1 list-style"
                                        href={`/${item.url}`}
                                   >
                                        <div className="inner">
                                             <div className="content">
                                                  <h5 className="title">{item.name}</h5>
                                                  <div className="read-more-btn">
                                                       <span className="rbt-btn-link">
                                                   
                                                            <i className="feather-arrow-right"></i>
                                                       </span>
                                                  </div>
                                             </div>
                                        </div>
                                   </Link>
                              </div>
                         );
                    })}
          </>
     );
};

export default CategorySix;
