import Image from "next/image";
import Link from "next/link";

import { Swiper, SwiperSlide } from "swiper/react";
import { EffectCards, Pagination } from "swiper/modules";

const HomeCourses = ({ start, end, isDesc = true, isUser=true, homeCourses}) => {
     return (
          <>
               <Swiper
                    className="swiper-wrapper"
                    effect={"cards"}
                    modules={[EffectCards, Pagination]}
                    grabCursor={true}
                    pagination={{
                         el: ".rbt-swiper-pagination",
                         clickable: true,
                    }}
               >
                    {homeCourses &&
                         homeCourses.map((data, index) => (
                              data.waiting == 0 &&
                              <SwiperSlide className="swiper-slide" key={index}>
                                   <div className="rbt-card variation-01 rbt-hover">
                                   <div className="rbt-card-img">
                                        <Link href={`/${data.url}`}>
                                             <Image
                                                  src={data.previewImage}
                                                  width={355}
                                                  height={244}
                                                  alt="Card image"
                                                  style={{ objectFit: 'cover' }}
                                             />
                                             {data.priceReduced > 0 ? (
                                                  <div className="rbt-badge-3 bg-white">
                                                       <span>-{data.price - data.priceReduced} RON</span>
                                                  </div>
                                             ) : (
                                                  ""
                                             )}
                                        </Link>
                                   </div>
                                   <div className="rbt-card-body">
                                        <div className="rbt-card-top">
                                             <div className="rbt-review">
                                                  <div className="rating">
                                                       {Array.from({ length: data.averageStars }, (_, index) => (
                                                            <i key={index} className="fas fa-star" style={{ color: '#FF9747' }}></i>
                                                       ))}
                                                  </div>
                                                  <span className="rating-count">
                                                       {data.totalReviews} Recenzii
                                                  </span>
                                             </div>
                                             <div className="rbt-bookmark-btn">
                                                  <Link className="rbt-round-btn" title="Bookmark" href="#">
                                                       <i className="feather-bookmark"></i>
                                                  </Link>
                                             </div>
                                        </div>

                                        <h1 className="rbt-card-title">
                                             <Link href={`/` + data.url}>
                                                  {data.title}
                                             </Link>
                                        </h1>

                                        <ul className="rbt-meta">
                                             <li>
                                                  <i className="feather-book"></i>
                                                  {data.lessonCount} Lecții
                                             </li>
                                        </ul>
                                        {isDesc ? <h2 className="rbt-card-text" style={{ marginBottom: 20, color:'#6b7385', fontSize: 17, lineHeight: 1.45 }}>{data.description}</h2> : ""}
                                        {isUser ? (
                                             <div className="rbt-author-meta mb--10">
                                                  <div className="rbt-avater">
                                                       <Link href={`/profile/${data.id}`}>
                                                            <Image
                                                                 src={data.instructorAvatar}
                                                                 width={33}
                                                                 height={33}
                                                                 alt="Sophia Jaymes"
                                                            />
                                                       </Link>
                                                  </div>
                                                  <div className="rbt-author-info">
                                                       De{" "}
                                                       <Link href={`/profile/${data.id}`}>
                                                            {data.instructorName}
                                                       </Link>{" "}
                                                       în{" "}
                                                       <Link href={'/' + data.categoryURL}>
                                                            {data.categoryName}
                                                       </Link>
                                                  </div>
                                             </div>
                                        ) : (
                                             ""
                                        )}
                                        <div className="rbt-card-bottom">
                                             <div className="rbt-price">
                                                  <span className="current-price">{data.priceReduced > 0 ? (data.priceReduced):(data.price)} RON</span>
                                                  {data.priceReduced > 0 && ( <span className="off-price">{data.price} RON</span> )}
                                             </div>
                                             {data.button ? (
                                                  <Link
                                                       className="rbt-btn-link left-icon"
                                                       href={`/${data.url}`}
                                                  >
                                                       <i className="feather-shopping-cart"></i> Adaugă în coș
                                                  </Link>
                                             ) : (
                                                  <Link
                                                       className="rbt-btn-link"
                                                       href={`/` + data.url}
                                                  >
                                                       Află mai mult<i className="feather-arrow-right"></i>
                                                  </Link>
                                             )}
                                        </div>
                                   </div>
                              </div>
                    
                              </SwiperSlide>
                         ))}
                    <div className="rbt-swiper-pagination"></div>
               </Swiper>
          </>
     );
};

export default HomeCourses;
